/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.exception.CorruptedNoteException;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFSNotebookRepo
implements NotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(VFSNotebookRepo.class);
    protected ZeppelinConfiguration conf;
    protected FileSystemManager fsManager;
    protected FileObject rootNotebookFileObject;
    protected String rootNotebookFolder;

    @Override
    public void init(ZeppelinConfiguration conf) throws IOException {
        this.conf = conf;
        this.setNotebookDirectory(conf.getNotebookDir());
    }

    protected void setNotebookDirectory(String notebookDirPath) throws IOException {
        URI filesystemRoot = null;
        try {
            LOGGER.info("Using notebookDir: {}", (Object)notebookDirPath);
            filesystemRoot = this.conf.isWindowsPath(notebookDirPath) ? new File(notebookDirPath).toURI() : new URI(notebookDirPath);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (filesystemRoot.getScheme() == null) {
            File f = new File(this.conf.getAbsoluteDir(filesystemRoot.getPath()));
            filesystemRoot = f.toURI();
        }
        this.fsManager = VFS.getManager();
        this.rootNotebookFileObject = this.fsManager.resolveFile(filesystemRoot);
        if (!this.rootNotebookFileObject.exists()) {
            this.rootNotebookFileObject.createFolder();
            LOGGER.info("Notebook dir doesn't exist: {}, creating it.", (Object)this.rootNotebookFileObject.getName().getPath());
        }
        this.rootNotebookFolder = this.rootNotebookFileObject.getName().getURI().replace("file:///", "/");
    }

    @Override
    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        this.rootNotebookFileObject = this.fsManager.resolveFile(this.rootNotebookFolder);
        return this.listFolder(this.rootNotebookFileObject);
    }

    private Map<String, NoteInfo> listFolder(FileObject fileObject) throws IOException {
        HashMap<String, NoteInfo> noteInfos;
        block5: {
            block4: {
                noteInfos = new HashMap<String, NoteInfo>();
                if (fileObject.getName().getBaseName().startsWith(".")) {
                    LOGGER.warn("Skip hidden item: {}", (Object)fileObject.getName());
                    return noteInfos;
                }
                if (!fileObject.isFolder()) break block4;
                for (FileObject child : fileObject.getChildren()) {
                    noteInfos.putAll(this.listFolder(child));
                }
                break block5;
            }
            String noteFileName = fileObject.getName().getURI().replace("file:///", "/");
            if (!noteFileName.endsWith(".zpln")) break block5;
            try {
                String noteId = this.getNoteId(noteFileName);
                String notePath = this.getNotePath(this.rootNotebookFolder, noteFileName);
                noteInfos.put(noteId, new NoteInfo(noteId, notePath));
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return noteInfos;
    }

    @Override
    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        FileObject noteFile = this.rootNotebookFileObject.resolveFile(this.buildNoteFileName(noteId, notePath), NameScope.DESCENDENT);
        String json = IOUtils.toString((InputStream)noteFile.getContent().getInputStream(), (String)this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING));
        try {
            Note note = Note.fromJson(noteId, json);
            note.setPath(notePath);
            return note;
        }
        catch (CorruptedNoteException e) {
            String errorMessage = String.format("Fail to parse note json. Please check the file at this path to resolve the issue. Path: %s, Content: %s", this.rootNotebookFolder + notePath, json);
            throw new CorruptedNoteException(noteId, errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void save(Note note, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Saving note {} to {}", (Object)note.getId(), (Object)this.buildNoteFileName(note));
        FileObject noteJson = this.rootNotebookFileObject.resolveFile(this.buildNoteTempFileName(note), NameScope.DESCENDENT);
        try (OutputStream out = null;){
            out = noteJson.getContent().getOutputStream(false);
            IOUtils.write((byte[])note.toJson().getBytes(this.conf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ENCODING)), (OutputStream)out);
        }
        noteJson.moveTo(this.rootNotebookFileObject.resolveFile(this.buildNoteFileName(note), NameScope.DESCENDENT));
    }

    @Override
    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move note {} from {} to {}", new Object[]{noteId, notePath, newNotePath});
        FileObject fileObject = this.rootNotebookFileObject.resolveFile(this.buildNoteFileName(noteId, notePath), NameScope.DESCENDENT);
        FileObject destFileObject = this.rootNotebookFileObject.resolveFile(this.buildNoteFileName(noteId, newNotePath), NameScope.DESCENDENT);
        destFileObject.getParent().createFolder();
        fileObject.moveTo(destFileObject);
    }

    @Override
    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Move folder from {} to {}", (Object)folderPath, (Object)newFolderPath);
        FileObject fileObject = this.rootNotebookFileObject.resolveFile(folderPath.substring(1), NameScope.DESCENDENT);
        FileObject destFileObject = this.rootNotebookFileObject.resolveFile(newFolderPath.substring(1), NameScope.DESCENDENT);
        destFileObject.getParent().createFolder();
        fileObject.moveTo(destFileObject);
    }

    @Override
    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove note: {}, notePath: {}", (Object)noteId, (Object)notePath);
        FileObject noteFile = this.rootNotebookFileObject.resolveFile(this.buildNoteFileName(noteId, notePath), NameScope.DESCENDENT);
        noteFile.delete(Selectors.SELECT_SELF);
    }

    @Override
    public void remove(String folderPath, AuthenticationInfo subject) throws IOException {
        LOGGER.info("Remove folder: {}", (Object)folderPath);
        FileObject folderObject = this.rootNotebookFileObject.resolveFile(folderPath.substring(1), NameScope.DESCENDENT);
        folderObject.deleteAll();
    }

    @Override
    public void close() {
    }

    @Override
    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        NotebookRepoSettingsInfo repoSetting = NotebookRepoSettingsInfo.newInstance();
        ArrayList<NotebookRepoSettingsInfo> settings = new ArrayList<NotebookRepoSettingsInfo>();
        repoSetting.name = "Notebook Path";
        repoSetting.type = NotebookRepoSettingsInfo.Type.INPUT;
        repoSetting.value = Collections.emptyList();
        repoSetting.selected = this.rootNotebookFileObject.getName().getPath();
        settings.add(repoSetting);
        return settings;
    }

    @Override
    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        if (settings == null || settings.isEmpty()) {
            LOGGER.error("Cannot update {} with empty settings", (Object)this.getClass().getName());
            return;
        }
        String newNotebookDirectotyPath = "";
        if (settings.containsKey("Notebook Path")) {
            newNotebookDirectotyPath = settings.get("Notebook Path");
        }
        if (StringUtils.isBlank((CharSequence)newNotebookDirectotyPath)) {
            LOGGER.error("Notebook path is invalid");
            return;
        }
        LOGGER.warn("{} will change notebook dir from {} to {}", new Object[]{subject.getUser(), this.rootNotebookFolder, newNotebookDirectotyPath});
        try {
            this.setNotebookDirectory(newNotebookDirectotyPath);
        }
        catch (IOException e) {
            LOGGER.error("Cannot update notebook directory", (Throwable)e);
        }
    }
}

