/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedInterpreterGroup
extends InterpreterGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedInterpreterGroup.class);
    private InterpreterSetting interpreterSetting;
    private RemoteInterpreterProcess remoteInterpreterProcess;
    private Object interpreterProcessCreationLock = new Object();

    ManagedInterpreterGroup(String id, InterpreterSetting interpreterSetting) {
        super(id);
        this.interpreterSetting = interpreterSetting;
    }

    public InterpreterSetting getInterpreterSetting() {
        return this.interpreterSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteInterpreterProcess getOrCreateInterpreterProcess(String userName, Properties properties) throws IOException {
        Object object = this.interpreterProcessCreationLock;
        synchronized (object) {
            if (this.remoteInterpreterProcess == null) {
                LOGGER.info("Create InterpreterProcess for InterpreterGroup: {}", (Object)this.getId());
                this.remoteInterpreterProcess = this.interpreterSetting.createInterpreterProcess(this.id, userName, properties);
                this.remoteInterpreterProcess.start(userName);
                this.remoteInterpreterProcess.init(ZeppelinConfiguration.create());
                this.getInterpreterSetting().getRecoveryStorage().onInterpreterClientStart((InterpreterClient)this.remoteInterpreterProcess);
            }
            return this.remoteInterpreterProcess;
        }
    }

    public RemoteInterpreterProcess getInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public void close() {
        LOGGER.info("Close InterpreterGroup: {}", (Object)this.id);
        for (String sessionId : this.sessions.keySet()) {
            this.close(sessionId);
        }
    }

    public synchronized void close(String sessionId) {
        LOGGER.info("Close Session: {} for interpreter setting: {}", (Object)sessionId, (Object)this.interpreterSetting.getName());
        this.close((Collection)this.sessions.remove(sessionId));
        if (this.sessions.isEmpty() && this.interpreterSetting != null) {
            LOGGER.info("Remove this InterpreterGroup: {} as all the sessions are closed", (Object)this.id);
            this.interpreterSetting.removeInterpreterGroup(this.id);
            if (this.remoteInterpreterProcess != null) {
                LOGGER.info("Kill RemoteInterpreterProcess");
                this.remoteInterpreterProcess.stop();
                try {
                    this.interpreterSetting.getRecoveryStorage().onInterpreterClientStop((InterpreterClient)this.remoteInterpreterProcess);
                }
                catch (IOException e) {
                    LOGGER.error("Fail to store recovery data", (Throwable)e);
                }
                this.remoteInterpreterProcess = null;
            }
        }
    }

    private void close(Collection<Interpreter> interpreters) {
        if (interpreters == null) {
            return;
        }
        List closeThreads = interpreters.stream().map(interpreter -> new Thread(() -> this.closeInterpreter((Interpreter)interpreter), interpreter.getClass().getSimpleName() + "-close")).peek(t -> t.setUncaughtExceptionHandler((th, e) -> LOGGER.error("Interpreter close error", e))).peek(Thread::start).collect(Collectors.toList());
        for (Thread t2 : closeThreads) {
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Can't wait interpreter close threads", (Throwable)e);
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInterpreter(Interpreter interpreter) {
        Scheduler scheduler = interpreter.getScheduler();
        try {
            if (Boolean.parseBoolean(interpreter.getProperty("zeppelin.interpreter.close.cancel_job", "true"))) {
                for (Job job : scheduler.getAllJobs()) {
                    if (job.isTerminated()) continue;
                    job.abort();
                    job.setStatus(Job.Status.ABORT);
                    LOGGER.info("Job {} aborted ", (Object)job.getJobName());
                }
            } else {
                LOGGER.info("Keep job running while closing interpreter: {}", (Object)interpreter.getClassName());
            }
            LOGGER.info("Trying to close interpreter {}", (Object)interpreter.getClassName());
            interpreter.close();
        }
        catch (InterpreterException e) {
            LOGGER.warn("Fail to close interpreter {}", (Object)interpreter.getClassName(), (Object)e);
        }
        finally {
            SchedulerFactory.singleton().removeScheduler(scheduler.getName());
        }
    }

    public synchronized List<Interpreter> getOrCreateSession(String user, String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return (List)this.sessions.get(sessionId);
        }
        List<Interpreter> interpreters = this.interpreterSetting.createInterpreters(user, this.id, sessionId);
        for (Interpreter interpreter : interpreters) {
            interpreter.setInterpreterGroup((InterpreterGroup)this);
        }
        LOGGER.info("Create Session: {} in InterpreterGroup: {} for user: {}", new Object[]{sessionId, this.id, user});
        this.sessions.put(sessionId, interpreters);
        return interpreters;
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }
}

