/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.newmatch;

import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.extend.AttributeResolver;
import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.extend.TreeResolver;
import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.newmatch.Selector;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.sheet.MediaRule;
import com.openhtmltopdf.css.sheet.PageRule;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.util.Util;
import com.openhtmltopdf.util.XRLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Matcher {
    private Mapper docMapper;
    private AttributeResolver _attRes;
    private TreeResolver _treeRes;
    private StylesheetFactory _styleFactory;
    private Map<Object, Mapper> _map;
    private Set<Object> _hoverElements;
    private Set<Object> _activeElements;
    private Set<Object> _focusElements;
    private Set<Object> _visitElements;
    private final List<PageRule> _pageRules = new ArrayList<PageRule>();
    private final List<FontFaceRule> _fontFaceRules = new ArrayList<FontFaceRule>();

    public Matcher(TreeResolver tr, AttributeResolver ar, StylesheetFactory factory, List<Stylesheet> stylesheets, String medium) {
        this.newMaps();
        this._treeRes = tr;
        this._attRes = ar;
        this._styleFactory = factory;
        this.docMapper = this.createDocumentMapper(stylesheets, medium);
    }

    public void removeStyle(Object e) {
        this._map.remove(e);
    }

    public CascadedStyle getCascadedStyle(Object e, boolean restyle) {
        Mapper em = !restyle ? this.getMapper(e) : this.matchElement(e);
        return em.getCascadedStyle(e);
    }

    public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
        Mapper em = this.getMapper(e);
        return em.getPECascadedStyle(e, pseudoElement);
    }

    public PageInfo getPageCascadedStyle(String pageName, String pseudoPage) {
        ArrayList<PropertyDeclaration> props = new ArrayList<PropertyDeclaration>();
        HashMap<MarginBoxName, List<PropertyDeclaration>> marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
        for (PageRule pageRule : this._pageRules) {
            if (!pageRule.applies(pageName, pseudoPage)) continue;
            props.addAll(pageRule.getRuleset().getPropertyDeclarations());
            marginBoxes.putAll(pageRule.getMarginBoxes());
        }
        CascadedStyle style = props.isEmpty() ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(props.iterator());
        return new PageInfo(props, style, marginBoxes);
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._fontFaceRules;
    }

    public boolean isVisitedStyled(Object e) {
        return this._visitElements.contains(e);
    }

    public boolean isHoverStyled(Object e) {
        return this._hoverElements.contains(e);
    }

    public boolean isActiveStyled(Object e) {
        return this._activeElements.contains(e);
    }

    public boolean isFocusStyled(Object e) {
        return this._focusElements.contains(e);
    }

    protected Mapper matchElement(Object e) {
        Mapper child;
        Object parent = this._treeRes.getParentElement(e);
        if (parent != null) {
            Mapper m = this.getMapper(parent);
            child = m.mapChild(e);
        } else {
            child = this.docMapper.mapChild(e);
        }
        return child;
    }

    Mapper createDocumentMapper(List<Stylesheet> stylesheets, String medium) {
        TreeMap<String, Selector> sorter = new TreeMap<String, Selector>();
        this.addAllStylesheets(stylesheets, sorter, medium);
        XRLog.match("Matcher created with " + sorter.size() + " selectors");
        return new Mapper(sorter.values());
    }

    private void addAllStylesheets(List<Stylesheet> stylesheets, TreeMap<String, Selector> sorter, String medium) {
        int count = 0;
        int pCount = 0;
        for (Stylesheet stylesheet : stylesheets) {
            for (Object obj : stylesheet.getContents()) {
                MediaRule mediaRule;
                if (obj instanceof Ruleset) {
                    for (Selector selector : ((Ruleset)obj).getFSSelectors()) {
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                    continue;
                }
                if (obj instanceof PageRule) {
                    ((PageRule)obj).setPos(++pCount);
                    this._pageRules.add((PageRule)obj);
                    continue;
                }
                if (!(obj instanceof MediaRule) || !(mediaRule = (MediaRule)obj).matches(medium)) continue;
                Iterator<Ruleset> iterator = mediaRule.getContents().iterator();
                while (iterator.hasNext()) {
                    Ruleset o;
                    Ruleset ruleset = o = iterator.next();
                    Iterator<Selector> iterator2 = ruleset.getFSSelectors().iterator();
                    while (iterator2.hasNext()) {
                        Selector o1;
                        Selector selector = o1 = iterator2.next();
                        selector.setPos(++count);
                        sorter.put(selector.getOrder(), selector);
                    }
                }
            }
            this._fontFaceRules.addAll(stylesheet.getFontFaceRules());
        }
        Collections.sort(this._pageRules, new Comparator<PageRule>(){

            @Override
            public int compare(PageRule p1, PageRule p2) {
                if (p1.getOrder() - p2.getOrder() < 0L) {
                    return -1;
                }
                if (p1.getOrder() == p2.getOrder()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    private void link(Object e, Mapper m) {
        this._map.put(e, m);
    }

    private void newMaps() {
        this._map = new HashMap<Object, Mapper>();
        this._hoverElements = new HashSet<Object>();
        this._activeElements = new HashSet<Object>();
        this._focusElements = new HashSet<Object>();
        this._visitElements = new HashSet<Object>();
    }

    private Mapper getMapper(Object e) {
        Mapper m = this._map.get(e);
        if (m != null) {
            return m;
        }
        m = this.matchElement(e);
        return m;
    }

    private Ruleset getElementStyle(Object e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getElementStyling(e);
        if (Util.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(2, style);
    }

    private Ruleset getNonCssStyle(Object e) {
        if (this._attRes == null || this._styleFactory == null) {
            return null;
        }
        String style = this._attRes.getNonCssStyling(e);
        if (Util.isNullOrEmpty(style)) {
            return null;
        }
        return this._styleFactory.parseStyleDeclaration(2, style);
    }

    class Mapper {
        List<Selector> axes;
        private HashMap<String, List<Selector>> pseudoSelectors;
        private List<Selector> mappedSelectors;
        private Map<String, Mapper> children;

        Mapper(Collection<Selector> selectors) {
            this.axes = new ArrayList<Selector>(selectors);
        }

        private Mapper() {
        }

        Mapper mapChild(Object e) {
            Mapper childMapper;
            ArrayList<Selector> childAxes = new ArrayList<Selector>(this.axes.size() + 10);
            HashMap<String, ArrayList<Selector>> pseudoSelectors = new HashMap<String, ArrayList<Selector>>();
            ArrayList<Selector> mappedSelectors = new ArrayList<Selector>();
            StringBuilder key = new StringBuilder();
            for (Selector sel : this.axes) {
                if (sel.getAxis() == 0) {
                    childAxes.add(sel);
                } else if (sel.getAxis() == 2) {
                    throw new RuntimeException();
                }
                if (!sel.matches(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                String pseudoElement = sel.getPseudoElement();
                if (pseudoElement != null) {
                    ArrayList<Selector> l = (ArrayList<Selector>)pseudoSelectors.get(pseudoElement);
                    if (l == null) {
                        l = new ArrayList<Selector>();
                        pseudoSelectors.put(pseudoElement, l);
                    }
                    l.add(sel);
                    key.append(sel.getSelectorID()).append(":");
                    continue;
                }
                if (sel.isPseudoClass(2)) {
                    Matcher.this._visitElements.add(e);
                }
                if (sel.isPseudoClass(8)) {
                    Matcher.this._activeElements.add(e);
                }
                if (sel.isPseudoClass(4)) {
                    Matcher.this._hoverElements.add(e);
                }
                if (sel.isPseudoClass(16)) {
                    Matcher.this._focusElements.add(e);
                }
                if (!sel.matchesDynamic(e, Matcher.this._attRes, Matcher.this._treeRes)) continue;
                key.append(sel.getSelectorID()).append(":");
                Selector chain = sel.getChainedSelector();
                if (chain == null) {
                    mappedSelectors.add(sel);
                    continue;
                }
                if (chain.getAxis() == 2) {
                    throw new RuntimeException();
                }
                childAxes.add(chain);
            }
            if (this.children == null) {
                this.children = new HashMap<String, Mapper>();
            }
            if ((childMapper = this.children.get(key.toString())) == null) {
                childMapper = new Mapper();
                childMapper.axes = childAxes;
                childMapper.pseudoSelectors = pseudoSelectors;
                childMapper.mappedSelectors = mappedSelectors;
                this.children.put(key.toString(), childMapper);
            }
            Matcher.this.link(e, childMapper);
            return childMapper;
        }

        CascadedStyle getCascadedStyle(Object e) {
            CascadedStyle cs = null;
            Ruleset elementStyling = Matcher.this.getElementStyle(e);
            Ruleset nonCssStyling = Matcher.this.getNonCssStyle(e);
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            if (nonCssStyling != null) {
                propList.addAll(nonCssStyling.getPropertyDeclarations());
            }
            for (Selector sel : this.mappedSelectors) {
                propList.addAll(sel.getRuleset().getPropertyDeclarations());
            }
            if (elementStyling != null) {
                propList.addAll(elementStyling.getPropertyDeclarations());
            }
            cs = propList.size() == 0 ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList.iterator());
            CascadedStyle result = cs;
            return result;
        }

        public CascadedStyle getPECascadedStyle(Object e, String pseudoElement) {
            Iterator<Map.Entry<String, List<Selector>>> si = this.pseudoSelectors.entrySet().iterator();
            if (!si.hasNext()) {
                return null;
            }
            CascadedStyle cs = null;
            List<Selector> pe = this.pseudoSelectors.get(pseudoElement);
            if (pe == null) {
                return null;
            }
            ArrayList<PropertyDeclaration> propList = new ArrayList<PropertyDeclaration>();
            for (Selector sel : pe) {
                propList.addAll(sel.getRuleset().getPropertyDeclarations());
            }
            cs = propList.size() == 0 ? CascadedStyle.emptyCascadedStyle : new CascadedStyle(propList.iterator());
            return cs;
        }
    }
}

