/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import com.google.common.collect.Maps;
import io.atomix.core.value.AsyncDistributedValue;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.value.DistributedValueType;
import io.atomix.core.value.ValueEvent;
import io.atomix.core.value.ValueEventListener;
import io.atomix.core.value.impl.BlockingDistributedValue;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.value.ValueDelegate;
import io.atomix.primitive.protocol.value.ValueDelegateEventListener;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.Event;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class GossipDistributedValue<V>
implements AsyncDistributedValue<V> {
    private final String name;
    private final PrimitiveProtocol protocol;
    private final ValueDelegate<V> value;
    private final Map<ValueEventListener<V>, ValueDelegateEventListener<V>> listenerMap = Maps.newConcurrentMap();

    public GossipDistributedValue(String name, PrimitiveProtocol protocol, ValueDelegate<V> value) {
        this.name = name;
        this.protocol = protocol;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public PrimitiveType type() {
        return DistributedValueType.instance();
    }

    public PrimitiveProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletableFuture<V> get() {
        try {
            return CompletableFuture.completedFuture(this.value.get());
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<V> getAndSet(V value) {
        try {
            return CompletableFuture.completedFuture(this.value.getAndSet(value));
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> set(V value) {
        try {
            this.value.set(value);
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> addListener(ValueEventListener<V> listener) {
        ValueDelegateEventListener eventListener = event -> listener.event((Event)new ValueEvent<Object>(ValueEvent.Type.UPDATE, event.value(), null));
        if (this.listenerMap.putIfAbsent(listener, eventListener) == null) {
            this.value.addListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeListener(ValueEventListener<V> listener) {
        ValueDelegateEventListener<V> eventListener = this.listenerMap.remove(listener);
        if (eventListener != null) {
            this.value.removeListener(eventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close() {
        try {
            this.value.close();
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return Futures.exceptionalFuture((Throwable)e);
        }
    }

    @Override
    public DistributedValue<V> sync(Duration operationTimeout) {
        return new BlockingDistributedValue(this, operationTimeout.toMillis());
    }
}

