/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.TransactionalMapParticipant;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class RepeatableReadsTransactionalMap<K, V>
extends TransactionalMapParticipant<K, V> {
    private final Map<K, CompletableFuture<Versioned<V>>> cache = Maps.newConcurrentMap();
    private final Map<K, MapUpdate<K, V>> updates = Maps.newConcurrentMap();

    public RepeatableReadsTransactionalMap(TransactionId transactionId, AsyncAtomicMap<K, V> consistentMap) {
        super(transactionId, consistentMap);
    }

    @Override
    public ProxyProtocol protocol() {
        return (ProxyProtocol)this.consistentMap.protocol();
    }

    private CompletableFuture<Versioned<V>> read(K key) {
        return this.cache.computeIfAbsent(key, this.consistentMap::get);
    }

    @Override
    public CompletableFuture<V> get(K key) {
        MapUpdate<K, V> update = this.updates.get(key);
        if (update != null) {
            if (update.type() == MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(update.value());
        }
        return this.read(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.read(key).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<V> put(K key, V value) {
        MapUpdate<K, V> update = this.updates.get(key);
        if (update != null && update.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
            this.updates.put(key, MapUpdate.builder().withType(update.type()).withKey(key).withValue(value).withVersion(update.version()).build());
        }
        return this.read(key).thenApply(versioned -> {
            if (versioned == null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(key).withValue(value).build());
                return null;
            }
            this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(key).withValue(value).withVersion(versioned.version()).build());
            return versioned.value();
        });
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        MapUpdate<K, V> update = this.updates.get(key);
        if (update != null && update.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
            return CompletableFuture.completedFuture(update.value());
        }
        return this.read(key).thenApply(versioned -> {
            if (versioned == null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(key).withValue(value).build());
                return null;
            }
            return versioned.value();
        });
    }

    @Override
    public CompletableFuture<V> remove(K key) {
        return this.read(key).thenApply(versioned -> {
            if (versioned != null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(key).withVersion(versioned.version()).build());
                return versioned.value();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        MapUpdate<K, V> update = this.updates.get(key);
        if (update != null && update.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH && !Objects.equals(update.value(), value)) {
            return CompletableFuture.completedFuture(false);
        }
        return this.read(key).thenApply(versioned -> {
            if (versioned != null && Objects.equals(versioned.value(), value)) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(key).withVersion(versioned.version()).build());
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        MapUpdate<K, V> update = this.updates.get(key);
        if (update != null && update.type() != MapUpdate.Type.REMOVE_IF_VERSION_MATCH) {
            if (Objects.equals(update.value(), oldValue)) {
                this.updates.put(key, MapUpdate.builder().withType(update.type()).withKey(key).withValue(newValue).withVersion(update.version()).build());
                return CompletableFuture.completedFuture(true);
            }
            return CompletableFuture.completedFuture(false);
        }
        return this.read(key).thenApply(versioned -> {
            if (versioned != null && Objects.equals(versioned.value(), oldValue)) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(key).withValue(newValue).withVersion(versioned.version()).build());
                return true;
            }
            return false;
        });
    }

    @Override
    public TransactionLog<MapUpdate<K, V>> log() {
        return new TransactionLog<MapUpdate<K, V>>(this.transactionId, 0L, Lists.newArrayList(this.updates.values()));
    }
}

