/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.semaphore.impl;

import io.atomix.core.semaphore.AsyncDistributedSemaphore;
import io.atomix.core.semaphore.DistributedSemaphore;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlockingDistributedSemaphore
extends DistributedSemaphore {
    private final AsyncDistributedSemaphore asyncSemaphore;
    private final Duration timeout;

    public BlockingDistributedSemaphore(AsyncDistributedSemaphore asyncSemaphore, Duration timeout) {
        this.asyncSemaphore = asyncSemaphore;
        this.timeout = timeout;
    }

    public String name() {
        return this.asyncSemaphore.name();
    }

    public PrimitiveType type() {
        return this.asyncSemaphore.type();
    }

    public PrimitiveProtocol protocol() {
        return this.asyncSemaphore.protocol();
    }

    @Override
    public void acquireUninterruptibly() {
        this.complete(this.asyncSemaphore.acquire());
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        this.complete(this.asyncSemaphore.acquire(permits));
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        this.complete(this.asyncSemaphore.acquire(permits));
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.complete(this.asyncSemaphore.tryAcquire(permits));
    }

    @Override
    public boolean tryAcquire(int permits, Duration timeout) throws InterruptedException {
        return this.complete(this.asyncSemaphore.tryAcquire(permits, timeout));
    }

    @Override
    public boolean tryAcquire() {
        return this.complete(this.asyncSemaphore.tryAcquire());
    }

    @Override
    public boolean tryAcquire(Duration timeout) throws InterruptedException {
        return this.complete(this.asyncSemaphore.tryAcquire(timeout));
    }

    @Override
    public void release() {
        this.complete(this.asyncSemaphore.release());
    }

    @Override
    public void release(int permits) {
        this.complete(this.asyncSemaphore.release(permits));
    }

    @Override
    public int availablePermits() {
        return this.complete(this.asyncSemaphore.availablePermits());
    }

    @Override
    public int drainPermits() {
        return this.complete(this.asyncSemaphore.drainPermits());
    }

    @Override
    protected void reducePermits(int reduction) {
        this.complete(this.asyncSemaphore.reducePermits(reduction));
    }

    @Override
    public boolean isFair() {
        return true;
    }

    @Override
    public AsyncDistributedSemaphore async() {
        return this.asyncSemaphore;
    }

    public void close() {
        this.complete(this.asyncSemaphore.close());
    }

    private <T> T complete(CompletableFuture<T> future) {
        return this.complete(future, 0);
    }

    private <T> T complete(CompletableFuture<T> future, int acquirePermits) {
        AtomicBoolean needRelease = new AtomicBoolean(false);
        try {
            return ((CompletableFuture)future.thenApply(version -> {
                if (needRelease.get() && version != null && acquirePermits > 0) {
                    this.asyncSemaphore.release(acquirePermits);
                }
                return version;
            })).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            needRelease.set(acquirePermits > 0);
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            needRelease.set(acquirePermits > 0);
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            needRelease.set(acquirePermits > 0);
            throw new PrimitiveException(e.getCause());
        }
    }
}

