/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.multiset.impl;

import com.google.common.collect.Multiset;
import io.atomix.core.collection.CollectionEventListener;
import io.atomix.core.iterator.SyncIterator;
import io.atomix.core.iterator.impl.BlockingIterator;
import io.atomix.core.multiset.AsyncDistributedMultiset;
import io.atomix.core.multiset.DistributedMultiset;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class BlockingDistributedMultiset<E>
extends Synchronous<AsyncDistributedMultiset<E>>
implements DistributedMultiset<E> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedMultiset<E> asyncSet;

    public BlockingDistributedMultiset(AsyncDistributedMultiset<E> asyncSet, long operationTimeoutMillis) {
        super(asyncSet);
        this.asyncSet = asyncSet;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncSet.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncSet.isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        return this.complete(this.asyncSet.contains(o));
    }

    @Override
    public boolean add(E e) {
        return this.complete(this.asyncSet.add(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.complete(this.asyncSet.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.complete(this.asyncSet.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.complete(this.asyncSet.addAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.complete(this.asyncSet.retainAll(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.complete(this.asyncSet.removeAll(c));
    }

    public int count(@Nullable Object element) {
        return this.complete(this.asyncSet.count(element));
    }

    public int add(@Nullable E element, int occurrences) {
        return this.complete(this.asyncSet.add(element, occurrences));
    }

    public int remove(@Nullable Object element, int occurrences) {
        return this.complete(this.asyncSet.remove(element, occurrences));
    }

    public int setCount(E element, int count) {
        return this.complete(this.asyncSet.setCount(element, count));
    }

    public boolean setCount(E element, int oldCount, int newCount) {
        return this.complete(this.asyncSet.setCount(element, oldCount, newCount));
    }

    @Override
    public DistributedSet<E> elementSet() {
        return new BlockingDistributedSet<E>(this.asyncSet.elementSet(), this.operationTimeoutMillis);
    }

    @Override
    public DistributedSet<Multiset.Entry<E>> entrySet() {
        return new BlockingDistributedSet(this.async().entrySet(), this.operationTimeoutMillis);
    }

    @Override
    public void clear() {
        this.complete(this.asyncSet.clear());
    }

    @Override
    public SyncIterator<E> iterator() {
        return new BlockingIterator(this.asyncSet.iterator(), this.operationTimeoutMillis);
    }

    @Override
    public Object[] toArray() {
        return this.stream().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] copy = this.toArray();
        System.arraycopy(copy, 0, array, 0, Math.min(copy.length, array.length));
        return array;
    }

    @Override
    public void addListener(CollectionEventListener<E> listener) {
        this.complete(this.asyncSet.addListener(listener));
    }

    @Override
    public void removeListener(CollectionEventListener<E> listener) {
        this.complete(this.asyncSet.removeListener(listener));
    }

    @Override
    public AsyncDistributedMultiset<E> async() {
        return this.asyncSet;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof PrimitiveException) {
                throw (PrimitiveException)e.getCause();
            }
            throw new PrimitiveException(e.getCause());
        }
    }
}

