/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.xwiki.macros.internal;

import com.vladsch.flexmark.ext.xwiki.macros.Macro;
import com.vladsch.flexmark.ext.xwiki.macros.MacroAttribute;
import com.vladsch.flexmark.ext.xwiki.macros.MacroBlock;
import com.vladsch.flexmark.ext.xwiki.macros.MacroClose;
import com.vladsch.flexmark.ext.xwiki.macros.internal.MacroOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MacroNodeRenderer
implements NodeRenderer {
    private final MacroOptions options;

    public MacroNodeRenderer(DataHolder options) {
        this.options = new MacroOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Macro.class, this::render));
        set.add(new NodeRenderingHandler(MacroAttribute.class, this::render));
        set.add(new NodeRenderingHandler(MacroClose.class, this::render));
        set.add(new NodeRenderingHandler(MacroBlock.class, this::render));
        return set;
    }

    private void render(Macro node, NodeRendererContext context, HtmlWriter html) {
        if (this.options.enableRendering) {
            html.text((CharSequence)Node.spanningChars((BasedSequence[])new BasedSequence[]{node.getOpeningMarker(), node.getClosingMarker()}));
            context.renderChildren((Node)node);
        }
    }

    private void render(MacroAttribute node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(MacroClose node, NodeRendererContext context, HtmlWriter html) {
        if (this.options.enableRendering) {
            html.text((CharSequence)Node.spanningChars((BasedSequence[])new BasedSequence[]{node.getOpeningMarker(), node.getClosingMarker()}));
        }
    }

    private void render(MacroBlock node, NodeRendererContext context, HtmlWriter html) {
        if (this.options.enableRendering) {
            context.renderChildren((Node)node);
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new MacroNodeRenderer(options);
        }
    }
}

