/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest.message;

import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.scheduler.Job;

public class ParagraphJobStatus {
    private final String id;
    private final String status;
    private String errorMessage;
    private String started;
    private String finished;
    private final String progress;

    public ParagraphJobStatus(Paragraph p) {
        this.id = p.getId();
        this.status = p.getStatus().toString();
        if (p.getDateStarted() != null) {
            this.started = p.getDateStarted().toString();
        }
        if (p.getDateFinished() != null) {
            this.finished = p.getDateFinished().toString();
        }
        if (p.getStatus().isRunning()) {
            this.progress = String.valueOf(p.progress());
        } else if (p.isTerminated()) {
            this.progress = String.valueOf(100);
            if (p.getStatus() == Job.Status.ERROR) {
                this.errorMessage = !StringUtils.isBlank((String)p.getErrorMessage()) ? p.getErrorMessage() : String.valueOf(p.getReturn());
            }
        } else {
            this.progress = String.valueOf(0);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStarted() {
        return this.started;
    }

    public String getFinished() {
        return this.finished;
    }

    public String getProgress() {
        return this.progress;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

