/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.auth.Credential;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.regions.DescribeEndpointResponse;
import com.aliyuncs.regions.DescribeEndpointService;
import com.aliyuncs.regions.DescribeEndpointServiceImpl;
import com.aliyuncs.regions.Endpoint;
import com.aliyuncs.regions.IEndpointsProvider;
import com.aliyuncs.regions.LocationConfig;
import com.aliyuncs.regions.ProductDomain;
import java.util.ArrayList;
import java.util.HashSet;

public class RemoteEndpointsParser
implements IEndpointsProvider {
    private DescribeEndpointService describeEndpointService;

    public void setDescribeEndpointService(DescribeEndpointService describeEndpointService) {
        this.describeEndpointService = describeEndpointService;
    }

    public static RemoteEndpointsParser initRemoteEndpointsParser() {
        RemoteEndpointsParser parser = new RemoteEndpointsParser();
        parser.setDescribeEndpointService(new DescribeEndpointServiceImpl());
        return parser;
    }

    @Override
    public Endpoint getEndpoint(String regionId, String product) throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Endpoint getEndpoint(String regionId, String product, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) throws ClientException {
        if (serviceCode == null) {
            return null;
        }
        Endpoint endpoint = null;
        DescribeEndpointResponse response = this.describeEndpointService.describeEndpoint(regionId, serviceCode, endpointType, credential, locationConfig);
        if (response == null) {
            return endpoint;
        }
        HashSet<String> regionIds = new HashSet<String>();
        regionIds.add(regionId);
        ArrayList<ProductDomain> productDomainList = new ArrayList<ProductDomain>();
        productDomainList.add(new ProductDomain(product, response.getEndpoint()));
        endpoint = new Endpoint(response.getRegionId(), regionIds, productDomainList);
        return endpoint;
    }
}

