/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static JsonElement deepCopy(JsonElement from) {
        if (from.isJsonObject()) {
            JsonObject result = new JsonObject();
            for (Map.Entry<String, JsonElement> entry : from.getAsJsonObject().entrySet()) {
                result.add(entry.getKey(), JsonUtils.deepCopy(entry.getValue()));
            }
            return result;
        }
        if (from.isJsonArray()) {
            JsonArray result = new JsonArray();
            for (JsonElement element : from.getAsJsonArray()) {
                result.add(element);
            }
            return result;
        }
        if (from.isJsonPrimitive()) {
            return from;
        }
        if (from.isJsonNull()) {
            return from;
        }
        return JsonNull.INSTANCE;
    }
}

