/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.Arguments;
import com.influxdb.client.FindOptions;
import com.influxdb.client.UsersApi;
import com.influxdb.client.domain.OperationLog;
import com.influxdb.client.domain.OperationLogs;
import com.influxdb.client.domain.PasswordResetBody;
import com.influxdb.client.domain.User;
import com.influxdb.client.domain.Users;
import com.influxdb.client.service.UsersService;
import com.influxdb.internal.AbstractRestClient;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import okhttp3.Credentials;
import retrofit2.Call;

final class UsersApiImpl
extends AbstractRestClient
implements UsersApi {
    private static final Logger LOG = Logger.getLogger(UsersApiImpl.class.getName());
    private final UsersService service;

    UsersApiImpl(@Nonnull UsersService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public User findUserByID(@Nonnull String userID) {
        Arguments.checkNonEmpty(userID, "User ID");
        Call<User> user = this.service.getUsersID(userID, null);
        return this.execute(user);
    }

    @Override
    @Nonnull
    public List<User> findUsers() {
        Call<Users> usersCall = this.service.getUsers(null);
        Users users = this.execute(usersCall);
        LOG.log(Level.FINEST, "findUsers found: {0}", users);
        return users.getUsers();
    }

    @Override
    @Nonnull
    public User createUser(@Nonnull String name) {
        Arguments.checkNonEmpty(name, "User name");
        User user = new User();
        user.setName(name);
        return this.createUser(user);
    }

    @Override
    @Nonnull
    public User createUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        Call<User> call = this.service.postUsers(user, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public User updateUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        Call<User> userCall = this.service.patchUsersID(user.getId(), user, null);
        return this.execute(userCall);
    }

    @Override
    public void updateUserPassword(@Nonnull User user, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(user, "User");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        this.updateUserPassword(user.getId(), user.getName(), oldPassword, newPassword);
    }

    @Override
    public void updateUserPassword(@Nonnull String userID, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(userID, "User ID");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        Call<User> userByID = this.service.getUsersID(userID, null);
        User user = this.execute(userByID);
        this.updateUserPassword(userID, user.getName(), oldPassword, newPassword);
    }

    @Override
    public void deleteUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        this.deleteUser(user.getId());
    }

    @Override
    public void deleteUser(@Nonnull String userID) {
        Arguments.checkNonEmpty(userID, "User ID");
        Call<Void> call = this.service.deleteUsersID(userID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public User cloneUser(@Nonnull String clonedName, @Nonnull String userID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(userID, "userID");
        User user = this.findUserByID(userID);
        return this.cloneUser(clonedName, user);
    }

    @Override
    @Nonnull
    public User cloneUser(@Nonnull String clonedName, @Nonnull User user) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(user, "User");
        User cloned = new User();
        cloned.setName(clonedName);
        return this.createUser(cloned);
    }

    @Override
    @Nonnull
    public User me() {
        Call<User> call = this.service.getMe(null);
        return this.execute(call);
    }

    @Override
    public void meUpdatePassword(@Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        User user = this.me();
        String credentials = Credentials.basic(user.getName(), oldPassword);
        PasswordResetBody passwordResetBody = new PasswordResetBody().password(newPassword);
        Call<Void> call = this.service.putMePassword(passwordResetBody, null, credentials);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<OperationLog> findUserLogs(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        return this.findUserLogs(user.getId());
    }

    @Override
    @Nonnull
    public List<OperationLog> findUserLogs(@Nonnull String userID) {
        Arguments.checkNonEmpty(userID, "User ID");
        return this.findUserLogs(userID, new FindOptions()).getLogs();
    }

    @Override
    @Nonnull
    public OperationLogs findUserLogs(@Nonnull User user, @Nonnull FindOptions findOptions) {
        Arguments.checkNotNull(user, "User");
        Arguments.checkNotNull(findOptions, "findOptions");
        return this.findUserLogs(user.getId(), findOptions);
    }

    @Override
    @Nonnull
    public OperationLogs findUserLogs(@Nonnull String userID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty(userID, "User ID");
        Arguments.checkNotNull(findOptions, "findOptions");
        Call<OperationLogs> call = this.service.getUsersIDLogs(userID, null, findOptions.getOffset(), findOptions.getLimit());
        return this.execute(call);
    }

    private void updateUserPassword(@Nonnull String userID, @Nonnull String userName, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(userID, "User ID");
        Arguments.checkNotNull(userName, "Username");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        String credentials = Credentials.basic(userName, oldPassword);
        PasswordResetBody resetBody = new PasswordResetBody().password(newPassword);
        Call<Void> call = this.service.putUsersIDPassword(userID, resetBody, null, credentials);
        this.execute(call);
    }
}

