/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.nbformat;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.jupyter.nbformat.Output;
import org.apache.zeppelin.jupyter.types.ZeppelinOutputType;
import org.apache.zeppelin.jupyter.zformat.TypeData;

public class Stream
extends Output {
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="text")
    private Object text;

    public List<String> getText() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.text instanceof String) {
            textList.add((String)this.text);
        } else {
            textList = (List)this.text;
        }
        return textList;
    }

    public boolean isError() {
        if (this.name == null) {
            return true;
        }
        return this.name.equals("stderr");
    }

    @Override
    public ZeppelinOutputType getTypeOfZeppelin() {
        return ZeppelinOutputType.TEXT;
    }

    @Override
    public TypeData toZeppelinResult() {
        List<String> text = Stream.verifyEndOfLine(this.getText());
        String result = StringUtils.join(text, (String)"");
        return new TypeData(this.getTypeOfZeppelin().toString(), result);
    }
}

