/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.ffi.provider.jffi;

import com.spotify.docker.client.shaded.jnr.ffi.mapper.AbstractSignatureTypeMapper;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeContext;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeType;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.FromNativeTypes;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.SignatureType;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.SignatureTypeMapper;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeContext;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeConverter;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeType;
import com.spotify.docker.client.shaded.jnr.ffi.mapper.ToNativeTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class AnnotationTypeMapper
extends AbstractSignatureTypeMapper
implements SignatureTypeMapper {
    @Override
    public FromNativeType getFromNativeType(SignatureType type, FromNativeContext context) {
        Method fromNativeMethod = AnnotationTypeMapper.findMethodWithAnnotation(type, FromNativeConverter.FromNative.class);
        if (fromNativeMethod == null) {
            return null;
        }
        if (!Modifier.isStatic(fromNativeMethod.getModifiers())) {
            throw new IllegalArgumentException(fromNativeMethod.getDeclaringClass().getName() + "." + fromNativeMethod.getName() + " should be declared static");
        }
        return FromNativeTypes.create(new ReflectionFromNativeConverter(fromNativeMethod, fromNativeMethod.getAnnotation(FromNativeConverter.FromNative.class).nativeType()));
    }

    @Override
    public ToNativeType getToNativeType(SignatureType type, ToNativeContext context) {
        Method toNativeMethod = AnnotationTypeMapper.findMethodWithAnnotation(type, ToNativeConverter.ToNative.class);
        if (toNativeMethod == null) {
            return null;
        }
        if (!Modifier.isStatic(toNativeMethod.getModifiers())) {
            throw new IllegalArgumentException(toNativeMethod.getDeclaringClass().getName() + "." + toNativeMethod.getName() + " should be declared static");
        }
        return ToNativeTypes.create(new ReflectionToNativeConverter(toNativeMethod, toNativeMethod.getAnnotation(ToNativeConverter.ToNative.class).nativeType()));
    }

    private static Method findMethodWithAnnotation(SignatureType type, Class<? extends Annotation> annotationClass) {
        for (Class klass = type.getDeclaredType(); klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            for (Method m : klass.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(annotationClass)) continue;
                return m;
            }
        }
        return null;
    }

    @ToNativeConverter.Cacheable
    public final class ReflectionToNativeConverter
    extends AbstractReflectionConverter
    implements ToNativeConverter<Object, Object> {
        public ReflectionToNativeConverter(Method method, Class nativeType) {
            super(method, nativeType);
        }

        @Override
        public Object toNative(Object nativeValue, ToNativeContext context) {
            return this.invoke(nativeValue, context);
        }
    }

    @FromNativeConverter.Cacheable
    public final class ReflectionFromNativeConverter
    extends AbstractReflectionConverter
    implements FromNativeConverter<Object, Object> {
        public ReflectionFromNativeConverter(Method method, Class nativeType) {
            super(method, nativeType);
        }

        @Override
        public Object fromNative(Object nativeValue, FromNativeContext context) {
            return this.invoke(nativeValue, context);
        }
    }

    public abstract class AbstractReflectionConverter {
        protected final Method method;
        protected final Class nativeType;

        public AbstractReflectionConverter(Method method, Class nativeType) {
            this.method = method;
            this.nativeType = nativeType;
        }

        protected final Object invoke(Object value, Object context) {
            try {
                return this.method.invoke(this.method.getDeclaringClass(), value, context);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }

        public final Class<Object> nativeType() {
            return this.nativeType;
        }
    }
}

