/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.lib.filter.Filter;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@JinjavaDoc(value="Uses whitespace to indent a string.", input={@JinjavaParam(value="string", desc="The string to indent", required=true)}, params={@JinjavaParam(value="width", type="number", defaultValue="4", desc="Amount of whitespace to indent"), @JinjavaParam(value="indentfirst", type="boolean", defaultValue="False", desc="If True, first line will be indented")}, snippets={@JinjavaSnippet(desc="Since HubSpot's compiler automatically strips whitespace, this filter will only work in tags where whitespace is retained, such as a <pre>", code="<pre>\n    {% set var = \"string to indent\" %}\n    {{ var|indent(2, true) }}\n</pre>")})
public class IndentFilter
implements Filter {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private static final Joiner NEWLINE_JOINER = Joiner.on((char)'\n');

    @Override
    public String getName() {
        return "indent";
    }

    @Override
    public Object filter(Object var, JinjavaInterpreter interpreter, String ... args) {
        int width = 4;
        if (args.length > 0) {
            width = NumberUtils.toInt((String)args[0], (int)4);
        }
        boolean indentFirst = false;
        if (args.length > 1) {
            indentFirst = BooleanUtils.toBoolean((String)args[1]);
        }
        ArrayList<String> indentedLines = new ArrayList<String>();
        for (String line : NEWLINE_SPLITTER.split((CharSequence)Objects.toString(var, ""))) {
            int thisWidth = indentedLines.size() == 0 && !indentFirst ? 0 : width;
            indentedLines.add(StringUtils.repeat((char)' ', (int)thisWidth) + line);
        }
        return NEWLINE_JOINER.join(indentedLines);
    }
}

