/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.internal;

import com.influxdb.Arguments;
import com.influxdb.Cancellable;
import com.influxdb.exceptions.InfluxException;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.query.internal.FluxCsvParser;
import com.influxdb.query.internal.FluxResultMapper;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class AbstractQueryApi
extends AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractQueryApi.class.getName());
    protected final FluxCsvParser fluxCsvParser = new FluxCsvParser();
    protected final FluxResultMapper resultMapper = new FluxResultMapper();
    protected static final Runnable EMPTY_ACTION = () -> {};
    protected static final JSONObject DEFAULT_DIALECT = new JSONObject().put("header", true).put("delimiter", ",").put("quoteChar", "\"").put("commentPrefix", "#").put("annotations", new JSONArray().put("datatype").put("group").put("default"));
    protected static final Consumer<Throwable> ERROR_CONSUMER = throwable -> {
        if (throwable instanceof InfluxException) {
            throw (InfluxException)throwable;
        }
        throw new InfluxException((Throwable)throwable);
    };

    @Nonnull
    protected RequestBody createBody(@Nullable String dialect, @Nonnull String query) {
        Arguments.checkNonEmpty(query, "Flux query");
        JSONObject json = new JSONObject().put("query", query);
        if (dialect != null && !dialect.isEmpty()) {
            json.put("dialect", new JSONObject(dialect));
        }
        return this.createBody(json.toString());
    }

    protected void query(@Nonnull Call<ResponseBody> queryCall, @Nonnull FluxCsvParser.FluxResponseConsumer responseConsumer, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                this.fluxCsvParser.parseFluxResponse((BufferedSource)bufferedSource, (Cancellable)cancellable, responseConsumer);
            }
            catch (IOException e) {
                onError.accept(e);
            }
        };
        this.query(queryCall, consumer, onError, onComplete, asynchronously);
    }

    protected void queryRaw(@Nonnull Call<ResponseBody> queryCall, @Nonnull BiConsumer<Cancellable, String> onResponse, @Nonnull Consumer<? super Throwable> onError, @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        BiConsumer<Cancellable, BufferedSource> consumer = (cancellable, bufferedSource) -> {
            try {
                this.parseFluxResponseToLines(line -> onResponse.accept((Cancellable)cancellable, (String)line), (Cancellable)cancellable, (BufferedSource)bufferedSource);
            }
            catch (IOException e) {
                this.catchOrPropagateException(e, onError);
            }
        };
        this.query(queryCall, consumer, onError, onComplete, asynchronously);
    }

    protected void query(@Nonnull Call<ResponseBody> query, final @Nonnull BiConsumer<Cancellable, BufferedSource> consumer, final @Nonnull Consumer<? super Throwable> onError, final @Nonnull Runnable onComplete, @Nonnull Boolean asynchronously) {
        Arguments.checkNotNull(query, "query");
        Arguments.checkNotNull(consumer, "consumer");
        Arguments.checkNotNull(onError, "onError");
        Arguments.checkNotNull(onComplete, "onComplete");
        Arguments.checkNotNull(asynchronously, "asynchronously");
        final DefaultCancellable cancellable = new DefaultCancellable();
        Callback<ResponseBody> callback = new Callback<ResponseBody>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(@Nonnull Call<ResponseBody> call, @Nonnull Response<ResponseBody> response) {
                if (!response.isSuccessful()) {
                    onError.accept(AbstractQueryApi.this.responseToError(response));
                    return;
                }
                ResponseBody body = response.body();
                if (body == null) {
                    return;
                }
                try {
                    BufferedSource source = body.source();
                    while (source.isOpen() && !source.exhausted() && !cancellable.wasCancelled) {
                        consumer.accept(cancellable, source);
                    }
                    if (!cancellable.wasCancelled) {
                        onComplete.run();
                    }
                }
                catch (Exception e) {
                    AbstractQueryApi.this.catchOrPropagateException(e, onError);
                }
                finally {
                    body.close();
                }
            }

            @Override
            public void onFailure(@Nonnull Call<ResponseBody> call, @Nonnull Throwable throwable) {
                onError.accept(throwable);
            }
        };
        LOG.log(Level.FINEST, "Prepared query {0}, asynchronously {1}", new Object[]{query, asynchronously});
        if (asynchronously.booleanValue()) {
            query.enqueue(callback);
        } else {
            try {
                Response<ResponseBody> response = query.execute();
                callback.onResponse(query, response);
            }
            catch (IOException e) {
                this.catchOrPropagateException(e, onError);
            }
        }
    }

    private void parseFluxResponseToLines(@Nonnull Consumer<String> onResponse, @Nonnull Cancellable cancellable, @Nonnull BufferedSource bufferedSource) throws IOException {
        String line = bufferedSource.readUtf8Line();
        while (line != null && !cancellable.isCancelled()) {
            onResponse.accept(line);
            line = bufferedSource.readUtf8Line();
        }
    }

    private class DefaultCancellable
    implements Cancellable {
        private volatile boolean wasCancelled = false;

        private DefaultCancellable() {
        }

        @Override
        public void cancel() {
            this.wasCancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.wasCancelled;
        }
    }
}

