/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface AsyncAtomicDocumentTree<V>
extends AsyncPrimitive {
    public DocumentPath root();

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath var1);

    public CompletableFuture<Versioned<V>> get(DocumentPath var1);

    public CompletableFuture<Versioned<V>> set(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> create(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> createRecursive(DocumentPath var1, V var2);

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, long var3);

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, V var3);

    public CompletableFuture<Versioned<V>> removeNode(DocumentPath var1);

    default public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeEventListener<V> listener) {
        return this.addListener(path, listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(DocumentPath var1, DocumentTreeEventListener<V> var2, Executor var3);

    public CompletableFuture<Void> removeListener(DocumentTreeEventListener<V> var1);

    default public CompletableFuture<Void> addListener(DocumentTreeEventListener<V> listener) {
        return this.addListener(this.root(), listener, MoreExecutors.directExecutor());
    }

    default public CompletableFuture<Void> addListener(DocumentTreeEventListener<V> listener, Executor executor) {
        return this.addListener(this.root(), listener, executor);
    }

    default public AtomicDocumentTree<V> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public AtomicDocumentTree<V> sync(Duration var1);
}

