/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.impl.SetUpdate;
import io.atomix.core.transaction.AsyncTransactionalSet;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionParticipant;
import io.atomix.core.transaction.TransactionalSet;
import io.atomix.core.transaction.impl.BlockingTransactionalSet;
import io.atomix.primitive.PrimitiveType;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class TransactionalSetParticipant<E>
implements AsyncTransactionalSet<E>,
TransactionParticipant<SetUpdate<E>> {
    protected final TransactionId transactionId;
    protected final AsyncDistributedSet<E> set;

    protected TransactionalSetParticipant(TransactionId transactionId, AsyncDistributedSet<E> set) {
        this.transactionId = (TransactionId)((Object)Preconditions.checkNotNull((Object)((Object)transactionId)));
        this.set = (AsyncDistributedSet)Preconditions.checkNotNull(set);
    }

    public String name() {
        return this.set.name();
    }

    public PrimitiveType type() {
        return this.set.type();
    }

    @Override
    public CompletableFuture<Boolean> prepare() {
        return this.set.prepare(this.log());
    }

    @Override
    public CompletableFuture<Void> commit() {
        return this.set.commit(this.transactionId);
    }

    @Override
    public CompletableFuture<Void> rollback() {
        return this.set.rollback(this.transactionId);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.set.close();
    }

    @Override
    public TransactionalSet<E> sync(Duration operationTimeout) {
        return new BlockingTransactionalSet(this, operationTimeout.toMillis());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

