/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.map;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.collection.AsyncDistributedCollection;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.transaction.Transactional;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface AsyncAtomicMap<K, V>
extends AsyncPrimitive,
Transactional<MapUpdate<K, V>> {
    default public CompletableFuture<Void> delete() {
        return this.clear();
    }

    public CompletableFuture<Integer> size();

    default public CompletableFuture<Boolean> isEmpty() {
        return this.size().thenApply(s -> s == 0);
    }

    public CompletableFuture<Boolean> containsKey(K var1);

    public CompletableFuture<Boolean> containsValue(V var1);

    public CompletableFuture<Versioned<V>> get(K var1);

    public CompletableFuture<Map<K, Versioned<V>>> getAllPresent(Iterable<K> var1);

    public CompletableFuture<Versioned<V>> getOrDefault(K var1, V var2);

    default public CompletableFuture<Versioned<V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIf(key, Objects::isNull, (k, v) -> mappingFunction.apply((Object)k));
    }

    default public CompletableFuture<Versioned<V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    default public CompletableFuture<Versioned<V>> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> computeIf(K var1, Predicate<? super V> var2, BiFunction<? super K, ? super V, ? extends V> var3);

    default public CompletableFuture<Versioned<V>> put(K key, V value) {
        return this.put(key, value, Duration.ZERO);
    }

    public CompletableFuture<Versioned<V>> put(K var1, V var2, Duration var3);

    default public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return this.putAndGet(key, value, Duration.ZERO);
    }

    public CompletableFuture<Versioned<V>> putAndGet(K var1, V var2, Duration var3);

    public CompletableFuture<Versioned<V>> remove(K var1);

    public CompletableFuture<Void> clear();

    public AsyncDistributedSet<K> keySet();

    public AsyncDistributedCollection<Versioned<V>> values();

    public AsyncDistributedSet<Map.Entry<K, Versioned<V>>> entrySet();

    default public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, Duration.ZERO);
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K var1, V var2, Duration var3);

    public CompletableFuture<Boolean> remove(K var1, V var2);

    public CompletableFuture<Boolean> remove(K var1, long var2);

    public CompletableFuture<Versioned<V>> replace(K var1, V var2);

    public CompletableFuture<Boolean> replace(K var1, V var2, V var3);

    public CompletableFuture<Boolean> replace(K var1, long var2, V var4);

    default public CompletableFuture<Void> addListener(AtomicMapEventListener<K, V> listener) {
        return this.addListener(listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(AtomicMapEventListener<K, V> var1, Executor var2);

    public CompletableFuture<Void> removeListener(AtomicMapEventListener<K, V> var1);

    default public AtomicMap<K, V> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public AtomicMap<K, V> sync(Duration var1);
}

