/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterConfig;
import io.atomix.core.profile.ProfileConfig;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.utils.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AtomixConfig
implements Config {
    private static final String MANAGEMENT_GROUP_NAME = "system";
    private ClusterConfig cluster = new ClusterConfig();
    private boolean enableShutdownHook;
    private PartitionGroupConfig managementGroup;
    private Map<String, PartitionGroupConfig<?>> partitionGroups = new HashMap();
    private Map<String, PrimitiveConfig> primitives = new HashMap<String, PrimitiveConfig>();
    private List<ProfileConfig> profiles = new ArrayList<ProfileConfig>();

    public ClusterConfig getClusterConfig() {
        return this.cluster;
    }

    public AtomixConfig setClusterConfig(ClusterConfig cluster) {
        this.cluster = cluster;
        return this;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public AtomixConfig setEnableShutdownHook(boolean enableShutdownHook) {
        this.enableShutdownHook = enableShutdownHook;
        return this;
    }

    public PartitionGroupConfig<?> getManagementGroup() {
        return this.managementGroup;
    }

    public AtomixConfig setManagementGroup(PartitionGroupConfig<?> managementGroup) {
        managementGroup.setName(MANAGEMENT_GROUP_NAME);
        this.managementGroup = managementGroup;
        return this;
    }

    public Map<String, PartitionGroupConfig<?>> getPartitionGroups() {
        return this.partitionGroups;
    }

    public AtomixConfig setPartitionGroups(Map<String, PartitionGroupConfig<?>> partitionGroups) {
        partitionGroups.forEach((name, group) -> group.setName(name));
        this.partitionGroups = partitionGroups;
        return this;
    }

    public AtomixConfig addPartitionGroup(PartitionGroupConfig partitionGroup) {
        this.partitionGroups.put(partitionGroup.getName(), partitionGroup);
        return this;
    }

    public Map<String, PrimitiveConfig> getPrimitives() {
        return this.primitives;
    }

    public AtomixConfig setPrimitives(Map<String, PrimitiveConfig> primitives) {
        this.primitives = (Map)Preconditions.checkNotNull(primitives);
        return this;
    }

    public AtomixConfig addPrimitive(String name, PrimitiveConfig config) {
        this.primitives.put(name, config);
        return this;
    }

    public <C extends PrimitiveConfig<C>> C getPrimitive(String name) {
        return (C)this.primitives.get(name);
    }

    public List<ProfileConfig> getProfiles() {
        return this.profiles;
    }

    public AtomixConfig setProfiles(List<ProfileConfig> profiles) {
        this.profiles = profiles;
        return this;
    }

    public AtomixConfig addProfile(ProfileConfig profile) {
        this.profiles.add((ProfileConfig)Preconditions.checkNotNull((Object)profile, (Object)"profile cannot be null"));
        return this;
    }
}

