/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.cluster.MemberId;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.serializer.serializers.DefaultSerializers;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ClusterCommunicationService {
    default public <M> void broadcast(String subject, M message) {
        this.broadcast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> void broadcast(String var1, M var2, Function<M, byte[]> var3);

    default public <M> void broadcastIncludeSelf(String subject, M message) {
        this.broadcastIncludeSelf(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M> void broadcastIncludeSelf(String var1, M var2, Function<M, byte[]> var3);

    default public <M> CompletableFuture<Void> unicast(String subject, M message, MemberId toMemberId) {
        return this.unicast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), toMemberId);
    }

    public <M> CompletableFuture<Void> unicast(String var1, M var2, Function<M, byte[]> var3, MemberId var4);

    default public <M> void multicast(String subject, M message, Set<MemberId> memberIds) {
        this.multicast(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), memberIds);
    }

    public <M> void multicast(String var1, M var2, Function<M, byte[]> var3, Set<MemberId> var4);

    default public <M, R> CompletableFuture<R> send(String subject, M message, MemberId toMemberId) {
        return this.send(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), toMemberId, null);
    }

    default public <M, R> CompletableFuture<R> send(String subject, M message, MemberId toMemberId, Duration timeout) {
        return this.send(subject, message, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), toMemberId, timeout);
    }

    default public <M, R> CompletableFuture<R> send(String subject, M message, Function<M, byte[]> encoder, Function<byte[], R> decoder, MemberId toMemberId) {
        return this.send(subject, message, encoder, decoder, toMemberId, null);
    }

    public <M, R> CompletableFuture<R> send(String var1, M var2, Function<M, byte[]> var3, Function<byte[], R> var4, MemberId var5, Duration var6);

    default public <M, R> CompletableFuture<Void> subscribe(String subject, Function<M, R> handler, Executor executor) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0), executor);
    }

    public <M, R> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Function<M, R> var3, Function<R, byte[]> var4, Executor var5);

    default public <M, R> CompletableFuture<Void> subscribe(String subject, Function<M, CompletableFuture<R>> handler) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, arg_0 -> ((Serializer)DefaultSerializers.BASIC).encode(arg_0));
    }

    public <M, R> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Function<M, CompletableFuture<R>> var3, Function<R, byte[]> var4);

    default public <M> CompletableFuture<Void> subscribe(String subject, Consumer<M> handler, Executor executor) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, executor);
    }

    default public <M> CompletableFuture<Void> subscribe(String subject, BiConsumer<Address, M> handler, Executor executor) {
        return this.subscribe(subject, arg_0 -> ((Serializer)DefaultSerializers.BASIC).decode(arg_0), handler, executor);
    }

    public <M> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, Consumer<M> var3, Executor var4);

    public <M> CompletableFuture<Void> subscribe(String var1, Function<byte[], M> var2, BiConsumer<Address, M> var3, Executor var4);

    public void unsubscribe(String var1);
}

