/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.util.BitSet;

public class GraphvizUtils {
    private static final char NBSP_CHAR = '\u00a0';
    private static final BitSet IS_UNICODE_WHITESPACE = new BitSet(65536);

    private static boolean isUnicodeWhitespace(char c) {
        return IS_UNICODE_WHITESPACE.get(c);
    }

    public static void htmlEncode(CharSequence unsafeStr, boolean turnNewlineIntoBreak, StringBuilder buf) {
        int n = unsafeStr.length();
        block22: for (int i = 0; i < n; ++i) {
            char c = unsafeStr.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block22;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block22;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block22;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block22;
                }
                case '\'': {
                    buf.append("&#x27;");
                    continue block22;
                }
                case '\\': {
                    buf.append("&lsol;");
                    continue block22;
                }
                case '/': {
                    buf.append("&#x2F;");
                    continue block22;
                }
                case '\u2014': {
                    buf.append("&mdash;");
                    continue block22;
                }
                case '\u2013': {
                    buf.append("&ndash;");
                    continue block22;
                }
                case '\u201c': {
                    buf.append("&ldquo;");
                    continue block22;
                }
                case '\u201d': {
                    buf.append("&rdquo;");
                    continue block22;
                }
                case '\u2018': {
                    buf.append("&lsquo;");
                    continue block22;
                }
                case '\u2019': {
                    buf.append("&rsquo;");
                    continue block22;
                }
                case '\u00ab': {
                    buf.append("&laquo;");
                    continue block22;
                }
                case '\u00bb': {
                    buf.append("&raquo;");
                    continue block22;
                }
                case '\u00a3': {
                    buf.append("&pound;");
                    continue block22;
                }
                case '\u00a9': {
                    buf.append("&copy;");
                    continue block22;
                }
                case '\u00ae': {
                    buf.append("&reg;");
                    continue block22;
                }
                case '\u00a0': {
                    buf.append("&nbsp;");
                    continue block22;
                }
                case '\n': {
                    if (turnNewlineIntoBreak) {
                        buf.append("<br>");
                        continue block22;
                    }
                    buf.append(' ');
                    continue block22;
                }
                default: {
                    if (c <= ' ' || GraphvizUtils.isUnicodeWhitespace(c)) {
                        buf.append(' ');
                        continue block22;
                    }
                    buf.append(c);
                }
            }
        }
    }

    public static void htmlEncode(CharSequence unsafeStr, StringBuilder buf) {
        GraphvizUtils.htmlEncode(unsafeStr, false, buf);
    }

    public static String htmlEncode(CharSequence unsafeStr) {
        StringBuilder buf = new StringBuilder(unsafeStr.length() * 2);
        GraphvizUtils.htmlEncode(unsafeStr, buf);
        return buf.toString();
    }

    static {
        String wsChars = "\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000";
        for (int i = 0; i < "\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000".length(); ++i) {
            IS_UNICODE_WHITESPACE.set("\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000".charAt(i));
        }
    }
}

