/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;

public class EquinoxContextFinderClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.eclipse.osgi.internal.framework.ContextFinder"};
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) throws Exception {
        Object parentContextClassLoader = ReflectionUtils.getFieldVal(classLoader, "parentContextClassLoader", false);
        if (parentContextClassLoader != null) {
            ClassLoaderHandler parentContextClassLoaderHandler = ClasspathFinder.findClassLoaderHandlerForClassLoader(scanSpec, classLoader, log);
            LogNode subLog = log;
            if (log != null) {
                subLog = log.log("Delegating to parentContextClassLoader: " + parentContextClassLoader);
            }
            parentContextClassLoaderHandler.handle(scanSpec, classLoader, classpathOrderOut, subLog);
        }
    }
}

