/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.scheduler.AbstractScheduler;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.SchedulerThreadFactory;
import org.apache.zeppelin.util.ExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelScheduler
extends AbstractScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelScheduler.class);
    private ExecutorService executor;

    ParallelScheduler(String name, int maxConcurrency) {
        super(name);
        this.executor = Executors.newFixedThreadPool(maxConcurrency, new SchedulerThreadFactory("ParallelScheduler-Worker-"));
    }

    @Override
    public void runJobInScheduler(Job<?> runningJob) {
        this.executor.execute(() -> this.runJob(runningJob));
    }

    @Override
    public void stop() {
        this.stop(2, TimeUnit.MINUTES);
    }

    @Override
    public void stop(int stopTimeoutVal, TimeUnit stopTimeoutUnit) {
        super.stop();
        ExecutorUtil.softShutdown(this.name, this.executor, stopTimeoutVal, stopTimeoutUnit);
    }
}

