/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import com.google.gson.internal.Primitives;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.resource.ByteBufferInputStream;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
implements JsonSerializable,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Resource.class);
    private static final Gson gson = new Gson();
    private final transient Object r;
    private final transient LocalResourcePool pool;
    private final boolean serializable;
    private final ResourceId resourceId;
    private final String className;

    Resource(LocalResourcePool pool, ResourceId resourceId, Object r) {
        this.r = r;
        this.pool = pool;
        this.resourceId = resourceId;
        this.serializable = r instanceof Serializable;
        this.className = r.getClass().getName();
    }

    Resource(LocalResourcePool pool, ResourceId resourceId, boolean serializable, String className) {
        this.r = null;
        this.pool = pool;
        this.resourceId = resourceId;
        this.serializable = serializable;
        this.className = className;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public String getClassName() {
        return this.className;
    }

    public Object get() {
        if (this.isLocal() || this.isSerializable()) {
            return this.r;
        }
        return null;
    }

    public <T> T get(Class<T> clazz) {
        return Primitives.wrap(clazz).cast(this.r);
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public boolean isLocal() {
        return true;
    }

    public Object invokeMethod(String methodName) {
        return this.invokeMethod(methodName, (Class[])null, (Object[])null);
    }

    public Resource invokeMethod(String methodName, String returnResourceName) {
        return this.invokeMethod(methodName, (Class[])null, (Object[])null, returnResourceName);
    }

    public Object invokeMethod(String methodName, Object[] params) throws ClassNotFoundException {
        return this.invokeMethod(methodName, (Type[])null, params);
    }

    public Object invokeMethod(String methodName, ArrayList params) throws ClassNotFoundException {
        Object[] paramsArray = params.toArray(new Object[0]);
        return this.invokeMethod(methodName, paramsArray);
    }

    public Resource invokeMethod(String methodName, Object[] params, String returnResourceName) throws ClassNotFoundException {
        return (Resource)this.invokeMethod(methodName, (Type[])null, params, returnResourceName);
    }

    public Resource invokeMethod(String methodName, ArrayList params, String returnResourceName) throws ClassNotFoundException {
        Object[] paramsArray = params.toArray(new Object[0]);
        return this.invokeMethod(methodName, paramsArray, returnResourceName);
    }

    public Object invokeMethod(String methodName, String[] paramTypes, Object[] params) throws ClassNotFoundException {
        Type[] types = this.typeFromName(paramTypes);
        return this.invokeMethod(methodName, types, params);
    }

    public Object invokeMethod(String methodName, ArrayList<String> paramTypes, ArrayList params) throws ClassNotFoundException {
        String[] paramTypesArray = paramTypes.toArray(new String[0]);
        Object[] paramsArray = params.toArray(new Object[0]);
        return this.invokeMethod(methodName, paramTypesArray, paramsArray);
    }

    public Resource invokeMethod(String methodName, String[] paramTypes, Object[] params, String returnResourceName) throws ClassNotFoundException {
        Type[] types = this.typeFromName(paramTypes);
        return (Resource)this.invokeMethod(methodName, types, params, returnResourceName);
    }

    public Resource invokeMethod(String methodName, ArrayList<String> paramTypes, ArrayList params, String returnResourceName) throws ClassNotFoundException {
        String[] paramTypesArray = paramTypes.toArray(new String[0]);
        Object[] paramsArray = params.toArray(new Object[0]);
        return this.invokeMethod(methodName, paramTypesArray, paramsArray, returnResourceName);
    }

    public Object invokeMethod(String methodName, Type[] types, Object[] params) throws ClassNotFoundException {
        return this.invokeMethod(methodName, types, params, null);
    }

    public Object invokeMethod(String methodName, Type[] types, Object[] params, String returnResourceName) throws ClassNotFoundException {
        Object[] convertedParams = null;
        Class[] classes = null;
        if (types != null) {
            convertedParams = this.convertParams(types, params);
            classes = this.classFromType(types);
        } else {
            Method[] methods;
            boolean found = false;
            for (Method m : methods = this.r.getClass().getDeclaredMethods()) {
                Type[] paramTypes;
                if (!m.getName().equals(methodName) || (paramTypes = m.getGenericParameterTypes()).length != params.length) continue;
                try {
                    convertedParams = this.convertParams(paramTypes, params);
                }
                catch (Exception e) {
                    LOGGER.info(String.format("The parameter types of method '%s' don't match with the arguments", m.getName()));
                    continue;
                }
                classes = this.classFromType(paramTypes);
                found = true;
                break;
            }
            if (!found) {
                throw new ClassNotFoundException("No method found for given parameters");
            }
        }
        if (returnResourceName == null) {
            return this.invokeMethod(methodName, classes, convertedParams);
        }
        return this.invokeMethod(methodName, classes, convertedParams, returnResourceName);
    }

    public Object invokeMethod(String methodName, Class[] paramTypes, Object[] params) {
        if (this.r != null) {
            try {
                Method method = this.r.getClass().getMethod(methodName, paramTypes);
                method.setAccessible(true);
                Object ret = method.invoke(this.r, params);
                return ret;
            }
            catch (Exception e) {
                this.logException(e);
                return null;
            }
        }
        return null;
    }

    public Resource invokeMethod(String methodName, Class[] paramTypes, Object[] params, String returnResourceName) {
        if (this.r != null) {
            try {
                Method method = this.r.getClass().getMethod(methodName, paramTypes);
                Object ret = method.invoke(this.r, params);
                this.pool.put(this.resourceId.getNoteId(), this.resourceId.getParagraphId(), returnResourceName, ret);
                return this.pool.get(this.resourceId.getNoteId(), this.resourceId.getParagraphId(), returnResourceName);
            }
            catch (Exception e) {
                this.logException(e);
                return null;
            }
        }
        return null;
    }

    public static ByteBuffer serializeObject(Object o) throws IOException {
        if (o == null || !(o instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o);
            oos.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static Object deserializeObject(ByteBuffer buf) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        InputStream ins = ByteBufferInputStream.get(buf);
        Object object = null;
        ObjectInputStream oin = new ObjectInputStream(ins);
        object = oin.readObject();
        oin.close();
        ins.close();
        return object;
    }

    private void logException(Exception e) {
        Logger logger = LoggerFactory.getLogger(Resource.class);
        logger.error(e.getMessage(), (Throwable)e);
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static Resource fromJson(String json) {
        return (Resource)gson.fromJson(json, Resource.class);
    }

    private ParameterizedType[] typeFromName(String[] classNames) throws ClassNotFoundException {
        if (classNames == null) {
            return null;
        }
        ParameterizedType[] types = new ParameterizedType[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            types[i] = this.typeFromName(classNames[i]);
        }
        return types;
    }

    private ParameterizedType typeFromName(String commaSeparatedClasses) throws ClassNotFoundException {
        Class[] arguments;
        String[] classNames = commaSeparatedClasses.split(",");
        if (classNames.length > 1) {
            arguments = new Class[classNames.length - 1];
            for (int i = 1; i < classNames.length; ++i) {
                arguments[i - 1] = this.loadClass(classNames[i]);
            }
        } else {
            arguments = new Class[]{};
        }
        final Class rawType = this.loadClass(classNames[0]);
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return arguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    private Class[] classFromType(Type[] types) throws ClassNotFoundException {
        Class[] cls = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i] instanceof ParameterizedType) {
                String typeName = ((ParameterizedType)types[i]).getRawType().getTypeName();
                cls[i] = this.loadClass(typeName);
                continue;
            }
            cls[i] = this.loadClass(types[i].getTypeName());
        }
        return cls;
    }

    private Object[] convertParams(Type[] types, Object[] params) {
        Object[] converted = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            String typeName = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType().getTypeName() : type.getTypeName();
            Object param = params[i];
            converted[i] = param == null ? null : (param.getClass().getName().equals(typeName) ? param : gson.fromJson(gson.toJson(param), type));
        }
        return converted;
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        switch (className) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        return this.getClass().getClassLoader().loadClass(className);
    }
}

