/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSCMYKColor;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxPerDocumentFormState;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.ArrayUtil;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionResetForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSubmitForm;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDComboBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDListBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.w3c.dom.Element;

public class PdfBoxForm {
    private final PdfBoxPerDocumentFormState docFormsStateContainer;
    private final PdfBoxOutputDevice od;
    private final Element element;
    private final List<ControlFontPair> controls = new ArrayList<ControlFontPair>();
    private final List<Control> submits = new ArrayList<Control>(2);
    private final Map<String, List<Control>> radioGroups = new LinkedHashMap<String, List<Control>>();
    private final Map<String, Field> allFieldMap = new HashMap<String, Field>();

    private PdfBoxForm(Element element, PdfBoxPerDocumentFormState forms, PdfBoxOutputDevice od) {
        this.element = element;
        this.od = od;
        this.docFormsStateContainer = forms;
    }

    public static PdfBoxForm createForm(Element e, PdfBoxPerDocumentFormState forms, PdfBoxOutputDevice od) {
        return new PdfBoxForm(e, forms, od);
    }

    public void addControl(Control ctrl, String fontName) {
        this.controls.add(new ControlFontPair(ctrl, fontName));
    }

    private void processControlNames() {
        for (ControlFontPair control : this.controls) {
            if (!((ControlFontPair)control).control.box.getElement().hasAttribute("name")) continue;
            String name = ((ControlFontPair)control).control.box.getElement().getAttribute("name");
            if (!name.contains(".")) {
                Field f = new Field();
                f.partialName = name;
                f.qualifiedName = name;
                f.isTerminal = true;
                this.allFieldMap.put(name, f);
                continue;
            }
            String[] partials = name.split(Pattern.quote("."));
            for (int i = 1; i <= partials.length; ++i) {
                String[] parent = new String[i];
                System.arraycopy(partials, 0, parent, 0, i);
                String parentQualifiedName = ArrayUtil.join(parent, ".");
                Field f = this.allFieldMap.get(parentQualifiedName);
                if (f != null) continue;
                Field fCreated = new Field();
                fCreated.qualifiedName = parentQualifiedName;
                fCreated.partialName = parent[i - 1];
                fCreated.isTerminal = i == partials.length;
                this.allFieldMap.put(parentQualifiedName, fCreated);
            }
        }
    }

    private void createNonTerminalFields(Field f, PDAcroForm form) {
        if (!f.isTerminal) {
            COSArray kids = new COSArray();
            for (Field f2 : this.allFieldMap.values()) {
                if (f2.qualifiedName.indexOf(f.qualifiedName) != 0 || f2.qualifiedName.length() <= f.qualifiedName.length() + 1 || f2.qualifiedName.substring(f.qualifiedName.length() + 1).contains(".")) continue;
                kids.add(f2.field.getCOSObject());
                f2.field.getCOSObject().setItem(COSName.PARENT, (COSBase)f.field.getCOSObject());
                this.createNonTerminalFields(f2, form);
            }
            f.field.getCOSObject().setItem(COSName.KIDS, (COSBase)kids);
        }
    }

    private void createNonTerminalFields(PDAcroForm form) {
        for (Field f : this.allFieldMap.values()) {
            if (f.isTerminal) continue;
            PDNonTerminalField nonTerminal = new PDNonTerminalField(form);
            nonTerminal.setPartialName(f.partialName);
            f.field = nonTerminal;
        }
        for (Field f : this.allFieldMap.values()) {
            if (f.qualifiedName.contains(".")) continue;
            this.createNonTerminalFields(f, form);
            form.getFields().add(f.field);
        }
    }

    private static String getColorOperator(FSColor color) {
        String colorOperator = "";
        if (color instanceof FSRGBColor) {
            FSRGBColor rgb = (FSRGBColor)color;
            float r = (float)rgb.getRed() / 255.0f;
            float g = (float)rgb.getGreen() / 255.0f;
            float b = (float)rgb.getBlue() / 255.0f;
            colorOperator = String.format(Locale.US, "%.4f", Float.valueOf(r)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(g)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(b)) + ' ' + "rg";
        } else if (color instanceof FSCMYKColor) {
            FSCMYKColor cmyk = (FSCMYKColor)color;
            float c = cmyk.getCyan();
            float m = cmyk.getMagenta();
            float y = cmyk.getYellow();
            float k = cmyk.getBlack();
            colorOperator = String.format(Locale.US, "%.4f", Float.valueOf(c)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(m)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(y)) + ' ' + String.format(Locale.US, "%.4f", Float.valueOf(k)) + ' ' + "k";
        }
        return colorOperator;
    }

    private String getTextareaText(Element e) {
        return DOMUtil.getText(e);
    }

    private String populateOptions(Element e, List<String> labels, List<String> values, List<Integer> selectedIndices) {
        List<Element> opts = DOMUtil.getChildren(e, "option");
        String selected = "";
        int i = 0;
        for (Element opt : opts) {
            String label = DOMUtil.getText(opt);
            labels.add(label);
            if (opt.hasAttribute("value")) {
                values.add(opt.getAttribute("value"));
            } else {
                values.add(label);
            }
            if (selected.isEmpty()) {
                selected = label;
            }
            if (opt.hasAttribute("selected")) {
                selected = label;
            }
            if (opt.hasAttribute("selected") && selectedIndices != null) {
                selectedIndices.add(i);
            }
            ++i;
        }
        return selected;
    }

    private void processMultiSelectControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root) throws IOException {
        PDListBox field = new PDListBox(acro);
        Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        field.setMultiSelect(true);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        this.populateOptions(ctrl.box.getElement(), labels, values, selected);
        field.setOptions(values, labels);
        field.setSelectedOptionsIndex(selected);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        PDAnnotationWidget widget = field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
    }

    private void processSelectControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root) throws IOException {
        PDComboBox field = new PDComboBox(acro);
        Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String selectedLabel = this.populateOptions(ctrl.box.getElement(), labels, values, null);
        field.setOptions(values, labels);
        field.setValue(selectedLabel);
        field.setDefaultValue(selectedLabel);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        if (ctrl.box.getElement().getNodeName().equals("openhtmltopdf-combo")) {
            field.setEdit(true);
            field.setCombo(true);
        }
        PDAnnotationWidget widget = field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
    }

    private void processHiddenControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root) throws IOException {
        PDTextField field = new PDTextField(acro);
        Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        String value = ctrl.box.getElement().getAttribute("value");
        field.setDefaultValue(value);
        field.setValue(value);
        PDAnnotationWidget widgy = field.getWidgets().get(0);
        widgy.setPage(ctrl.page);
        widgy.setHidden(true);
        widgy.setRectangle(new PDRectangle(0.0f, 0.0f, 1.0f, 1.0f));
        ctrl.page.getAnnotations().add(widgy);
    }

    private void processTextControl(ControlFontPair pair, Control ctrl, PDAcroForm acro, int i, Box root) throws IOException {
        PDTextField field = new PDTextField(acro);
        Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        FSColor color = ctrl.box.getStyle().getColor();
        String colorOperator = PdfBoxForm.getColorOperator(color);
        String fontInstruction = "/" + pair.fontName + " 0 Tf";
        field.setDefaultAppearance(fontInstruction + ' ' + colorOperator);
        String value = ctrl.box.getElement().getNodeName().equals("textarea") ? this.getTextareaText(ctrl.box.getElement()) : ctrl.box.getElement().getAttribute("value");
        field.setDefaultValue(value);
        field.setValue(value);
        if (OpenUtil.parseIntegerOrNull(ctrl.box.getElement().getAttribute("max-length")) != null) {
            field.setMaxLen(OpenUtil.parseIntegerOrNull(ctrl.box.getElement().getAttribute("max-length")));
        }
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        if (ctrl.box.getElement().getNodeName().equals("textarea")) {
            field.setMultiline(true);
        } else if (ctrl.box.getElement().getAttribute("type").equals("password")) {
            field.setPassword(true);
        } else if (ctrl.box.getElement().getAttribute("type").equals("file")) {
            XRLog.general(Level.WARNING, "Acrobat Reader does not support forms with file input controls");
            field.setFileSelect(true);
        }
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        PDAnnotationWidget widget = field.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        ctrl.page.getAnnotations().add(widget);
    }

    public static PDAppearanceStream createCheckboxAppearance(CheckboxStyle style, PDDocument doc, PDResources resources) {
        String appear = "q\nBT\n1 0 0 1 15 20 Tm\n/OpenHTMLZap 100 Tf\n(" + (char)style.caption + ") Tj\nET\nQ\n";
        return PdfBoxForm.createCheckboxAppearance(appear, doc, resources);
    }

    public static PDAppearanceStream createCheckboxAppearance(String appear, PDDocument doc, PDResources resources) {
        PDAppearanceStream s = new PDAppearanceStream(doc);
        s.setBBox(new PDRectangle(100.0f, 100.0f));
        OutputStream os = null;
        try {
            os = s.getContentStream().createOutputStream();
            os.write(appear.getBytes("ASCII"));
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("createCheckboxAppearance", e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
        s.setResources(resources);
        return s;
    }

    private COSString getCOSStringUTF16Encoded(String value) throws UnsupportedEncodingException {
        byte[] data = value.getBytes("UTF-16BE");
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
        out.write(254);
        out.write(255);
        try {
            out.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = out.toByteArray();
        COSString valueEncoded = new COSString(bytes);
        return valueEncoded;
    }

    private void processCheckboxControl(ControlFontPair pair, PDAcroForm acro, int i, Control ctrl, Box root) throws IOException {
        PDCheckBox field = new PDCheckBox(acro);
        Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        if (ctrl.box.getElement().hasAttribute("required")) {
            field.setRequired(true);
        }
        if (ctrl.box.getElement().hasAttribute("readonly")) {
            field.setReadOnly(true);
        }
        COSArray arr = new COSArray();
        arr.add(this.getCOSStringUTF16Encoded(ctrl.box.getElement().getAttribute("value")));
        field.getCOSObject().setItem(COSName.OPT, (COSBase)arr);
        if (ctrl.box.getElement().hasAttribute("title")) {
            field.setAlternateFieldName(ctrl.box.getElement().getAttribute("title"));
        }
        COSName zero = COSName.getPDFName("0");
        if (ctrl.box.getElement().hasAttribute("checked")) {
            field.getCOSObject().setItem(COSName.AS, (COSBase)zero);
            field.getCOSObject().setItem(COSName.V, (COSBase)zero);
            field.getCOSObject().setItem(COSName.DV, (COSBase)zero);
        } else {
            field.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
            field.getCOSObject().setItem(COSName.V, (COSBase)COSName.Off);
            field.getCOSObject().setItem(COSName.DV, (COSBase)COSName.Off);
        }
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        PDAnnotationWidget widget = field.getWidgets().get(0);
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        widget.setPrinted(true);
        CheckboxStyle style = CheckboxStyle.fromIdent(ctrl.box.getStyle().getIdent(CSSName.FS_CHECKBOX_STYLE));
        PDAppearanceCharacteristicsDictionary appearanceCharacteristics = new PDAppearanceCharacteristicsDictionary(new COSDictionary());
        appearanceCharacteristics.setNormalCaption(String.valueOf((char)style.caption));
        widget.setAppearanceCharacteristics(appearanceCharacteristics);
        COSDictionary dict = new COSDictionary();
        dict.setItem(zero, (COSObjectable)this.docFormsStateContainer.getCheckboxStyle(style));
        dict.setItem(COSName.Off, (COSObjectable)this.docFormsStateContainer.getCheckboxOffStream());
        PDAppearanceDictionary appearanceDict = new PDAppearanceDictionary();
        appearanceDict.getCOSObject().setItem(COSName.N, (COSBase)dict);
        widget.setAppearance(appearanceDict);
        ctrl.page.getAnnotations().add(widget);
    }

    private void processRadioButtonGroup(List<Control> group, PDAcroForm acro, int i, Box root) throws IOException {
        String groupName = group.get((int)0).box.getElement().getAttribute("name");
        PDRadioButton field = new PDRadioButton(acro);
        Field fObj = this.allFieldMap.get(groupName);
        fObj.field = field;
        field.setPartialName(fObj.partialName);
        ArrayList<String> values = new ArrayList<String>(group.size());
        for (Control ctrl : group) {
            values.add(ctrl.box.getElement().getAttribute("value"));
        }
        field.setExportValues(values);
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>(group.size());
        int radioCnt = 0;
        for (Control ctrl : group) {
            Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
            PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
            PDAnnotationWidget widget = new PDAnnotationWidget();
            widget.setRectangle(rect);
            widget.setPage(ctrl.page);
            widget.setPrinted(true);
            COSDictionary dict = new COSDictionary();
            dict.setItem(COSName.getPDFName("" + radioCnt), (COSObjectable)this.docFormsStateContainer.getRadioOnStream());
            dict.setItem(COSName.Off, (COSObjectable)this.docFormsStateContainer.getRadioOffStream());
            PDAppearanceDictionary appearanceDict = new PDAppearanceDictionary();
            appearanceDict.getCOSObject().setItem(COSName.N, (COSBase)dict);
            if (ctrl.box.getElement().hasAttribute("checked")) {
                widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.getPDFName("" + radioCnt));
            } else {
                widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
            }
            widget.setAppearance(appearanceDict);
            widgets.add(widget);
            ctrl.page.getAnnotations().add(widget);
            ++radioCnt;
        }
        field.setWidgets(widgets);
        for (Control ctrl : group) {
            if (!ctrl.box.getElement().hasAttribute("checked")) continue;
            field.setValue(ctrl.box.getElement().getAttribute("value"));
        }
    }

    private void processSubmitControl(PDAcroForm acro, int i, Control ctrl, Box root) throws IOException {
        int FLAG_USE_GET = 8;
        int FLAG_USE_HTML_SUBMIT = 4;
        PDPushButton btn = new PDPushButton(acro);
        btn.setPushButton(true);
        if (ctrl.box.getElement().hasAttribute("name")) {
            PDTextField field = new PDTextField(acro);
            Field fObj = this.allFieldMap.get(ctrl.box.getElement().getAttribute("name"));
            fObj.field = field;
            field.setPartialName(fObj.partialName);
            String value = ctrl.box.getElement().getAttribute("value");
            field.setDefaultValue(value);
            field.setValue(value);
            PDAnnotationWidget widgy = field.getWidgets().get(0);
            widgy.setPage(ctrl.page);
            widgy.setHidden(true);
            widgy.setRectangle(new PDRectangle(0.0f, 0.0f, 1.0f, 1.0f));
            ctrl.page.getAnnotations().add(widgy);
        }
        btn.setPartialName("OpenHTMLCtrl" + i);
        PDAnnotationWidget widget = btn.getWidgets().get(0);
        Rectangle2D rect2D = PdfBoxLinkManager.createTargetArea(ctrl.c, ctrl.box, ctrl.pageHeight, ctrl.transform, root, this.od);
        PDRectangle rect = new PDRectangle((float)rect2D.getMinX(), (float)rect2D.getMinY(), (float)rect2D.getWidth(), (float)rect2D.getHeight());
        widget.setRectangle(rect);
        widget.setPage(ctrl.page);
        COSArrayList<String> fieldsToInclude = new COSArrayList<String>();
        for (Field f : this.allFieldMap.values()) {
            if (!f.isTerminal) continue;
            fieldsToInclude.add(f.qualifiedName);
        }
        if (ctrl.box.getElement().getAttribute("type").equals("reset")) {
            PDActionResetForm reset = new PDActionResetForm();
            reset.setFields(fieldsToInclude.toList());
            widget.setAction(reset);
        } else {
            PDFileSpecification fs = PDFileSpecification.createFS(new COSString(this.element.getAttribute("action")));
            PDActionSubmitForm submit = new PDActionSubmitForm();
            submit.setFields(fieldsToInclude.toList());
            submit.setFile(fs);
            if (!this.element.getAttribute("method").equalsIgnoreCase("post")) {
                XRLog.general(Level.WARNING, "Using GET request method for form. You probably meant to add a method=\"post\" attribute to your form");
                submit.setFlags(12);
            } else {
                submit.setFlags(4);
            }
            widget.setAction(submit);
        }
        acro.getFields().add(btn);
        ctrl.page.getAnnotations().add(widget);
    }

    public int process(PDAcroForm acro, int startId, Box root) throws IOException {
        this.processControlNames();
        int i = startId;
        for (ControlFontPair controlFontPair : this.controls) {
            ++i;
            Control ctrl = controlFontPair.control;
            Element e = ctrl.box.getElement();
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("text") || e.getNodeName().equals("textarea") || e.getNodeName().equals("input") && e.getAttribute("type").equals("password") || e.getNodeName().equals("input") && e.getAttribute("type").equals("file")) {
                this.processTextControl(controlFontPair, ctrl, acro, i, root);
                continue;
            }
            if (e.getNodeName().equals("select") && !e.hasAttribute("multiple") || e.getNodeName().equals("openhtmltopdf-combo")) {
                this.processSelectControl(controlFontPair, ctrl, acro, i, root);
                continue;
            }
            if (e.getNodeName().equals("select") && e.hasAttribute("multiple")) {
                this.processMultiSelectControl(controlFontPair, ctrl, acro, i, root);
                continue;
            }
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("checkbox")) {
                this.processCheckboxControl(controlFontPair, acro, i, ctrl, root);
                continue;
            }
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("hidden")) {
                this.processHiddenControl(controlFontPair, ctrl, acro, i, root);
                continue;
            }
            if (e.getNodeName().equals("input") && e.getAttribute("type").equals("radio")) {
                List<Control> radioGroup = this.radioGroups.get(e.getAttribute("name"));
                if (radioGroup == null) {
                    radioGroup = new ArrayList<Control>();
                    this.radioGroups.put(e.getAttribute("name"), radioGroup);
                }
                radioGroup.add(ctrl);
                continue;
            }
            if (!(e.getNodeName().equals("input") && e.getAttribute("type").equals("submit") || e.getNodeName().equals("button") && !e.getAttribute("type").equals("button")) && (!e.getNodeName().equals("input") || !e.getAttribute("type").equals("reset"))) continue;
            this.submits.add(ctrl);
        }
        for (List list : this.radioGroups.values()) {
            this.processRadioButtonGroup(list, acro, ++i, root);
        }
        for (Control control : this.submits) {
            this.processSubmitControl(acro, ++i, control, root);
        }
        this.createNonTerminalFields(acro);
        return i;
    }

    public static enum CheckboxStyle {
        CHECK(52),
        CROSS(53),
        DIAMOND(117),
        CIRCLE(108),
        STAR(72),
        SQUARE(110);

        private final int caption;

        private CheckboxStyle(int caption) {
            this.caption = caption;
        }

        public static CheckboxStyle fromIdent(IdentValue id) {
            if (id == IdentValue.CHECK) {
                return CHECK;
            }
            if (id == IdentValue.CROSS) {
                return CROSS;
            }
            if (id == IdentValue.SQUARE) {
                return SQUARE;
            }
            if (id == IdentValue.CIRCLE) {
                return CIRCLE;
            }
            if (id == IdentValue.DIAMOND) {
                return DIAMOND;
            }
            if (id == IdentValue.STAR) {
                return STAR;
            }
            return CHECK;
        }
    }

    private static class ControlFontPair {
        private final String fontName;
        private final Control control;

        private ControlFontPair(Control control, String fontName) {
            this.control = control;
            this.fontName = fontName;
        }
    }

    public static class Control {
        public final Box box;
        private final PDPage page;
        private final AffineTransform transform;
        private final RenderingContext c;
        private final float pageHeight;

        public Control(Box box, PDPage page, AffineTransform transform, RenderingContext c, float pageHeight) {
            this.box = box;
            this.page = page;
            this.transform = transform;
            this.c = c;
            this.pageHeight = pageHeight;
        }
    }

    private static class Field {
        private PDField field;
        private String partialName;
        private String qualifiedName;
        private boolean isTerminal;

        private Field() {
        }
    }
}

