/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.ConfInterpreter;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionConfInterpreter
extends ConfInterpreter {
    private static Logger LOGGER = LoggerFactory.getLogger(SessionConfInterpreter.class);

    public SessionConfInterpreter(Properties properties, String sessionId, String interpreterGroupId, InterpreterSetting interpreterSetting) {
        super(properties, sessionId, interpreterGroupId, interpreterSetting);
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        try {
            Properties finalProperties = new Properties();
            finalProperties.putAll((Map<?, ?>)this.properties);
            Properties updatedProperties = new Properties();
            updatedProperties.load(new StringReader(st));
            finalProperties.putAll((Map<?, ?>)updatedProperties);
            LOGGER.debug("Properties for Session: {}:{}", (Object)this.sessionId, (Object)finalProperties);
            List interpreters = this.interpreterSetting.getInterpreterGroup(this.interpreterGroupId).get(this.sessionId);
            for (Interpreter intp : interpreters) {
                if (!(intp instanceof RemoteInterpreter)) continue;
                RemoteInterpreter remoteInterpreter = (RemoteInterpreter)intp;
                if (remoteInterpreter.isOpened()) {
                    return new InterpreterResult(InterpreterResult.Code.ERROR, "Can not change interpreter session properties after this session is started");
                }
                remoteInterpreter.setProperties(finalProperties);
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        catch (IOException e) {
            LOGGER.error("Fail to update interpreter setting", (Throwable)e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

