/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithSettings;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.rest.message.NotebookRepoSettingsRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notebook-repositories")
@Produces(value={"application/json"})
@Singleton
public class NotebookRepoRestApi
extends AbstractRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRepoRestApi.class);
    private final NotebookRepoSync noteRepos;
    private final NotebookServer notebookWsServer;

    @Inject
    public NotebookRepoRestApi(NotebookRepoSync noteRepos, NotebookServer notebookWsServer, AuthenticationService authenticationService) {
        super(authenticationService);
        this.noteRepos = noteRepos;
        this.notebookWsServer = notebookWsServer;
        this.authenticationService = authenticationService;
    }

    @GET
    @ZeppelinApi
    public Response listRepoSettings() {
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        LOG.info("Getting list of NoteRepo with Settings for user {}", (Object)subject.getUser());
        List settings = this.noteRepos.getNotebookRepos(subject);
        return new JsonResponse<List>(Response.Status.OK, "", settings).build();
    }

    @GET
    @Path(value="reload")
    @ZeppelinApi
    public Response refreshRepo() {
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        LOG.info("Reloading notebook repository for user {}", (Object)subject.getUser());
        try {
            this.notebookWsServer.broadcastReloadedNoteList(this.getServiceContext());
        }
        catch (IOException e) {
            LOG.error("Fail to refresh repo", (Throwable)e);
        }
        return new JsonResponse<Object>(Response.Status.OK, "", null).build();
    }

    @PUT
    @ZeppelinApi
    public Response updateRepoSetting(String payload) {
        NotebookRepoSettingsRequest newSettings;
        if (StringUtils.isBlank((CharSequence)payload)) {
            return new JsonResponse(Response.Status.NOT_FOUND, "", Collections.emptyMap()).build();
        }
        AuthenticationInfo subject = new AuthenticationInfo(this.authenticationService.getPrincipal());
        try {
            newSettings = (NotebookRepoSettingsRequest)GSON.fromJson(payload, NotebookRepoSettingsRequest.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Cannot update notebook repo settings", (Throwable)e);
            return new JsonResponse<ImmutableMap>(Response.Status.NOT_ACCEPTABLE, "", ImmutableMap.of((Object)"error", (Object)"Invalid payload structure")).build();
        }
        if (NotebookRepoSettingsRequest.isEmpty(newSettings)) {
            LOG.error("Invalid property");
            return new JsonResponse<ImmutableMap>(Response.Status.NOT_ACCEPTABLE, "", ImmutableMap.of((Object)"error", (Object)"Invalid payload")).build();
        }
        LOG.info("User {} is going to change repo setting", (Object)subject.getUser());
        NotebookRepoWithSettings updatedSettings = this.noteRepos.updateNotebookRepo(newSettings.getName(), newSettings.getSettings(), subject);
        if (!updatedSettings.isEmpty()) {
            LOG.info("Broadcasting note list to user {}", (Object)subject.getUser());
            try {
                this.notebookWsServer.broadcastReloadedNoteList(this.getServiceContext());
            }
            catch (IOException e) {
                LOG.error("Fail to refresh repo.", (Throwable)e);
            }
        }
        return new JsonResponse<NotebookRepoWithSettings>(Response.Status.OK, "", updatedSettings).build();
    }
}

