/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.enxio.channels;

import com.spotify.docker.client.shaded.jnr.constants.platform.Errno;
import com.spotify.docker.client.shaded.jnr.enxio.channels.Native;
import java.io.IOException;
import java.nio.ByteBuffer;

final class Common {
    private int _fd = -1;

    Common(int fd) {
        this._fd = fd;
    }

    void setFD(int fd) {
        this._fd = fd;
    }

    int getFD() {
        return this._fd;
    }

    int read(ByteBuffer dst) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(dst.remaining());
        int n = Native.read(this._fd, buffer);
        buffer.flip();
        dst.put(buffer);
        switch (n) {
            case 0: {
                return -1;
            }
            case -1: {
                Errno lastError = Native.getLastError();
                switch (lastError) {
                    case EAGAIN: 
                    case EWOULDBLOCK: {
                        return 0;
                    }
                }
                throw new IOException(Native.getLastErrorString());
            }
        }
        return n;
    }

    long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long total = 0L;
        for (int i = 0; i < length; ++i) {
            ByteBuffer dst = dsts[offset + i];
            long read = this.read(dst);
            if (read == -1L) {
                return read;
            }
            total += read;
        }
        return total;
    }

    int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(src.remaining());
        buffer.put(src);
        buffer.position(0);
        int n = Native.write(this._fd, buffer);
        if (n < 0) {
            switch (Native.getLastError()) {
                case EAGAIN: 
                case EWOULDBLOCK: {
                    return 0;
                }
            }
            throw new IOException(Native.getLastErrorString());
        }
        return n;
    }

    long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long result = 0L;
        int index = 0;
        for (index = offset; index < length; ++index) {
            result += (long)this.write(srcs[index]);
        }
        return result;
    }
}

