/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.GcpLaunchStage;
import com.google.cloud.ReadChannel;
import com.google.cloud.Tuple;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Blob
extends BlobInfo {
    private static final long serialVersionUID = -6806832496717441434L;
    private final StorageOptions options;
    private transient Storage storage;
    static final Function<Tuple<Storage, StorageObject>, Blob> BLOB_FROM_PB_FUNCTION = new Function<Tuple<Storage, StorageObject>, Blob>(){

        public Blob apply(Tuple<Storage, StorageObject> pb) {
            return Blob.fromPb((Storage)pb.x(), (StorageObject)pb.y());
        }
    };
    private static final int DEFAULT_CHUNK_SIZE = 0x200000;

    public void downloadTo(Path path, BlobSourceOption ... options) {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
             ReadChannel reader = this.reader(options);){
            WritableByteChannel channel = Channels.newChannel(outputStream);
            ByteBuffer bytes = ByteBuffer.allocate(0x200000);
            while (reader.read(bytes) > 0) {
                bytes.flip();
                channel.write(bytes);
                bytes.clear();
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void downloadTo(Path path) {
        this.downloadTo(path, new BlobSourceOption[0]);
    }

    Blob(Storage storage, BlobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.options = (StorageOptions)storage.getOptions();
    }

    public boolean exists(BlobSourceOption ... options) {
        int length = options.length;
        Storage.BlobGetOption[] getOptions = Arrays.copyOf(BlobSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BlobGetOption.fields(new Storage.BlobField[0]);
        return this.storage.get(this.getBlobId(), getOptions) != null;
    }

    public byte[] getContent(BlobSourceOption ... options) {
        return this.storage.readAllBytes(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public Blob reload(BlobSourceOption ... options) {
        return this.storage.get(this.getBlobId(), BlobSourceOption.toGetOptions(this, options));
    }

    public Blob update(Storage.BlobTargetOption ... options) {
        return this.storage.update((BlobInfo)this, options);
    }

    public boolean delete(BlobSourceOption ... options) {
        return this.storage.delete(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public CopyWriter copyTo(BlobId targetBlob, BlobSourceOption ... options) {
        Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(this.getBucket(), this.getName()).setSourceOptions(BlobSourceOption.toSourceOptions(this, options)).setTarget(targetBlob).build();
        return this.storage.copy(copyRequest);
    }

    public CopyWriter copyTo(String targetBucket, BlobSourceOption ... options) {
        return this.copyTo(targetBucket, this.getName(), options);
    }

    public CopyWriter copyTo(String targetBucket, String targetBlob, BlobSourceOption ... options) {
        return this.copyTo(BlobId.of(targetBucket, targetBlob), options);
    }

    public ReadChannel reader(BlobSourceOption ... options) {
        return this.storage.reader(this.getBlobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public WriteChannel writer(Storage.BlobWriteOption ... options) {
        return this.storage.writer(this, options);
    }

    public URL signUrl(long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(this, duration, unit, options);
    }

    public Acl getAcl(Acl.Entity entity) {
        return this.storage.getAcl(this.getBlobId(), entity);
    }

    public boolean deleteAcl(Acl.Entity entity) {
        return this.storage.deleteAcl(this.getBlobId(), entity);
    }

    public Acl createAcl(Acl acl) {
        return this.storage.createAcl(this.getBlobId(), acl);
    }

    public Acl updateAcl(Acl acl) {
        return this.storage.updateAcl(this.getBlobId(), acl);
    }

    public List<Acl> listAcls() {
        return this.storage.listAcls(this.getBlobId());
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Blob.class)) {
            return false;
        }
        Blob other = (Blob)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.getService();
    }

    static Blob fromPb(Storage storage, StorageObject storageObject) {
        BlobInfo info = BlobInfo.fromPb(storageObject);
        return new Blob(storage, new BlobInfo.BuilderImpl(info));
    }

    public static class Builder
    extends BlobInfo.Builder {
        private final Storage storage;
        private final BlobInfo.BuilderImpl infoBuilder;

        Builder(Blob blob) {
            this.storage = blob.getStorage();
            this.infoBuilder = new BlobInfo.BuilderImpl(blob);
        }

        @Override
        public Builder setBlobId(BlobId blobId) {
            this.infoBuilder.setBlobId(blobId);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        public Builder setContentType(String contentType) {
            this.infoBuilder.setContentType(contentType);
            return this;
        }

        @Override
        public Builder setContentDisposition(String contentDisposition) {
            this.infoBuilder.setContentDisposition(contentDisposition);
            return this;
        }

        @Override
        public Builder setContentLanguage(String contentLanguage) {
            this.infoBuilder.setContentLanguage(contentLanguage);
            return this;
        }

        @Override
        public Builder setContentEncoding(String contentEncoding) {
            this.infoBuilder.setContentEncoding(contentEncoding);
            return this;
        }

        @Override
        Builder setComponentCount(Integer componentCount) {
            this.infoBuilder.setComponentCount(componentCount);
            return this;
        }

        @Override
        public Builder setCacheControl(String cacheControl) {
            this.infoBuilder.setCacheControl(cacheControl);
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.infoBuilder.setAcl(acl);
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.infoBuilder.setOwner(owner);
            return this;
        }

        @Override
        Builder setSize(Long size) {
            this.infoBuilder.setSize(size);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setMd5(String md5) {
            this.infoBuilder.setMd5(md5);
            return this;
        }

        @Override
        public Builder setCrc32c(String crc32c) {
            this.infoBuilder.setCrc32c(crc32c);
            return this;
        }

        @Override
        Builder setMediaLink(String mediaLink) {
            this.infoBuilder.setMediaLink(mediaLink);
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, String> metadata) {
            this.infoBuilder.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.infoBuilder.setStorageClass(storageClass);
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.infoBuilder.setMetageneration(metageneration);
            return this;
        }

        @Override
        Builder setDeleteTime(Long deleteTime) {
            this.infoBuilder.setDeleteTime(deleteTime);
            return this;
        }

        @Override
        Builder setUpdateTime(Long updateTime) {
            this.infoBuilder.setUpdateTime(updateTime);
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.infoBuilder.setCreateTime(createTime);
            return this;
        }

        @Override
        Builder setIsDirectory(boolean isDirectory) {
            this.infoBuilder.setIsDirectory(isDirectory);
            return this;
        }

        @Override
        Builder setCustomerEncryption(BlobInfo.CustomerEncryption customerEncryption) {
            this.infoBuilder.setCustomerEncryption(customerEncryption);
            return this;
        }

        @Override
        public Blob build() {
            return new Blob(this.storage, this.infoBuilder);
        }
    }

    public static class BlobSourceOption
    extends Option {
        private static final long serialVersionUID = 214616862061934846L;

        private BlobSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private BlobSourceOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private Storage.BlobSourceOption toSourceOptions(BlobInfo blobInfo) {
            switch (this.getRpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobSourceOption.generationMatch(blobInfo.getGeneration());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.generationNotMatch(blobInfo.getGeneration());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobSourceOption.metagenerationMatch(blobInfo.getMetageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.metagenerationNotMatch(blobInfo.getMetageneration());
                }
                case CUSTOMER_SUPPLIED_KEY: {
                    return Storage.BlobSourceOption.decryptionKey((String)this.getValue());
                }
                case USER_PROJECT: {
                    return Storage.BlobSourceOption.userProject((String)this.getValue());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BlobGetOption toGetOption(BlobInfo blobInfo) {
            switch (this.getRpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobGetOption.generationMatch(blobInfo.getGeneration());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.generationNotMatch(blobInfo.getGeneration());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobGetOption.metagenerationMatch(blobInfo.getMetageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.metagenerationNotMatch(blobInfo.getMetageneration());
                }
                case USER_PROJECT: {
                    return Storage.BlobGetOption.userProject((String)this.getValue());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH);
        }

        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobSourceOption metagenerationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BlobSourceOption metagenerationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BlobSourceOption decryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobSourceOption decryptionKey(String key) {
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        @GcpLaunchStage.Alpha
        public static BlobSourceOption userProject(String userProject) {
            return new BlobSourceOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        static Storage.BlobSourceOption[] toSourceOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobSourceOption[] convertedOptions = new Storage.BlobSourceOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOptions(blobInfo);
            }
            return convertedOptions;
        }

        static Storage.BlobGetOption[] toGetOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobGetOption[] convertedOptions = new Storage.BlobGetOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(blobInfo);
            }
            return convertedOptions;
        }
    }
}

