/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AuthFastLeaderElection
implements Election {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFastLeaderElection.class);
    static int sequencer = 0;
    static int maxTag = 0;
    static int finalizeWait = 100;
    static int challengeCounter = 0;
    private boolean authEnabled = false;
    LinkedBlockingQueue<ToSend> sendqueue;
    LinkedBlockingQueue<Notification> recvqueue;
    QuorumPeer self;
    int port;
    AtomicLong logicalclock = new AtomicLong();
    DatagramSocket mySocket;
    long proposedLeader;
    long proposedZxid;

    public AuthFastLeaderElection(QuorumPeer self, boolean auth) {
        this.authEnabled = auth;
        this.starter(self);
    }

    public AuthFastLeaderElection(QuorumPeer self) {
        this.starter(self);
    }

    private void starter(QuorumPeer self) {
        this.self = self;
        this.port = self.getVotingView().get((Object)Long.valueOf((long)self.getId())).electionAddr.getPort();
        this.proposedLeader = -1L;
        this.proposedZxid = -1L;
        try {
            this.mySocket = new DatagramSocket(this.port);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            throw new RuntimeException();
        }
        this.sendqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        this.recvqueue = new LinkedBlockingQueue(2 * self.getVotingView().size());
        new Messenger(self.getVotingView().size() * 2, this.mySocket);
    }

    private void leaveInstance() {
        this.logicalclock.incrementAndGet();
    }

    private void sendNotifications() {
        for (QuorumPeer.QuorumServer server : this.self.getView().values()) {
            ToSend notmsg = new ToSend(ToSend.mType.notification, sequencer++, this.proposedLeader, this.proposedZxid, this.logicalclock.get(), QuorumPeer.ServerState.LOOKING, this.self.getView().get((Object)Long.valueOf((long)server.id)).electionAddr);
            this.sendqueue.offer(notmsg);
        }
    }

    private boolean totalOrderPredicate(long id2, long zxid) {
        return zxid > this.proposedZxid || zxid == this.proposedZxid && id2 > this.proposedLeader;
    }

    private boolean termPredicate(HashMap<InetSocketAddress, Vote> votes, long l, long zxid) {
        Collection<Vote> votesCast = votes.values();
        int count2 = 0;
        for (Vote v : votesCast) {
            if (v.getId() != l || v.getZxid() != zxid) continue;
            ++count2;
        }
        return count2 > this.self.getVotingView().size() / 2;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            HashMap<InetSocketAddress, Vote> recvset = new HashMap<InetSocketAddress, Vote>();
            HashMap<InetSocketAddress, Vote> outofelection = new HashMap<InetSocketAddress, Vote>();
            this.logicalclock.incrementAndGet();
            this.proposedLeader = this.self.getId();
            this.proposedZxid = this.self.getLastLoggedZxid();
            LOG.info("Election tally");
            this.sendNotifications();
            while (this.self.getPeerState() == QuorumPeer.ServerState.LOOKING) {
                Notification n = this.recvqueue.poll(2 * finalizeWait, TimeUnit.MILLISECONDS);
                if (n == null) {
                    if (!outofelection.isEmpty() || recvset.size() > 1) {
                        this.sendNotifications();
                    }
                    continue;
                }
                switch (n.state) {
                    case LOOKING: {
                        if (n.epoch > this.logicalclock.get()) {
                            this.logicalclock.set(n.epoch);
                            recvset.clear();
                            if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                this.proposedLeader = n.leader;
                                this.proposedZxid = n.zxid;
                            }
                            this.sendNotifications();
                        } else {
                            if (n.epoch < this.logicalclock.get()) break;
                            if (this.totalOrderPredicate(n.leader, n.zxid)) {
                                this.proposedLeader = n.leader;
                                this.proposedZxid = n.zxid;
                                this.sendNotifications();
                            }
                        }
                        recvset.put(n.addr, new Vote(n.leader, n.zxid));
                        if (this.self.getVotingView().size() == recvset.size()) {
                            this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                            this.leaveInstance();
                            Vote vote = new Vote(this.proposedLeader, this.proposedZxid);
                            return vote;
                        }
                        if (!this.termPredicate(recvset, this.proposedLeader, this.proposedZxid)) break;
                        LOG.info("Passed predicate");
                        Thread.sleep(finalizeWait);
                        while (!this.recvqueue.isEmpty() && !this.totalOrderPredicate(this.recvqueue.peek().leader, this.recvqueue.peek().zxid)) {
                            this.recvqueue.poll();
                        }
                        if (!this.recvqueue.isEmpty()) break;
                        this.self.setPeerState(this.proposedLeader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(this.proposedLeader, this.proposedZxid);
                        return vote;
                    }
                    case LEADING: {
                        outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                        if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(n.leader, n.zxid);
                        return vote;
                    }
                    case FOLLOWING: {
                        outofelection.put(n.addr, new Vote(n.leader, n.zxid));
                        if (!this.termPredicate(outofelection, n.leader, n.zxid)) break;
                        this.self.setPeerState(n.leader == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                        this.leaveInstance();
                        Vote vote = new Vote(n.leader, n.zxid);
                        return vote;
                    }
                }
            }
            Vote vote = null;
            return vote;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
    }

    private class Messenger {
        final DatagramSocket mySocket;
        long lastProposedLeader;
        long lastProposedZxid;
        long lastEpoch;
        final Set<Long> ackset;
        final ConcurrentHashMap<Long, Long> challengeMap;
        final ConcurrentHashMap<Long, Semaphore> challengeMutex;
        final ConcurrentHashMap<Long, Semaphore> ackMutex;
        final ConcurrentHashMap<InetSocketAddress, ConcurrentHashMap<Long, Long>> addrChallengeMap;

        Messenger(int threads, DatagramSocket s2) {
            this.mySocket = s2;
            this.ackset = Collections.newSetFromMap(new ConcurrentHashMap());
            this.challengeMap = new ConcurrentHashMap();
            this.challengeMutex = new ConcurrentHashMap();
            this.ackMutex = new ConcurrentHashMap();
            this.addrChallengeMap = new ConcurrentHashMap();
            this.lastProposedLeader = 0L;
            this.lastProposedZxid = 0L;
            this.lastEpoch = 0L;
            for (int i2 = 0; i2 < threads; ++i2) {
                Thread t = new Thread((Runnable)new WorkerSender(3), "WorkerSender Thread: " + (i2 + 1));
                t.setDaemon(true);
                t.start();
            }
            for (QuorumPeer.QuorumServer server : AuthFastLeaderElection.this.self.getVotingView().values()) {
                InetSocketAddress saddr = new InetSocketAddress(server.addr.getAddress(), AuthFastLeaderElection.this.port);
                this.addrChallengeMap.put(saddr, new ConcurrentHashMap());
            }
            Thread t = new Thread((Runnable)new WorkerReceiver(s2, this), "WorkerReceiver Thread");
            t.start();
        }

        class WorkerSender
        extends ZooKeeperThread {
            Random rand;
            int maxAttempts;
            int ackWait;

            WorkerSender(int attempts) {
                super("WorkerSender");
                this.ackWait = finalizeWait;
                this.maxAttempts = attempts;
                this.rand = new Random(Thread.currentThread().getId() + Time.currentElapsedTime());
            }

            long genChallenge() {
                byte[] buf = new byte[8];
                buf[0] = (byte)((challengeCounter & 0xFF000000) >>> 24);
                buf[1] = (byte)((challengeCounter & 0xFF0000) >>> 16);
                buf[2] = (byte)((challengeCounter & 0xFF00) >>> 8);
                buf[3] = (byte)(challengeCounter & 0xFF);
                ++challengeCounter;
                int secret = this.rand.nextInt(Integer.MAX_VALUE);
                buf[4] = (byte)((secret & 0xFF000000) >>> 24);
                buf[5] = (byte)((secret & 0xFF0000) >>> 16);
                buf[6] = (byte)((secret & 0xFF00) >>> 8);
                buf[7] = (byte)(secret & 0xFF);
                return ((long)(buf[0] & 0xFF) << 56) + ((long)(buf[1] & 0xFF) << 48) + ((long)(buf[2] & 0xFF) << 40) + ((long)(buf[3] & 0xFF) << 32) + ((long)(buf[4] & 0xFF) << 24) + ((long)(buf[5] & 0xFF) << 16) + ((long)(buf[6] & 0xFF) << 8) + (long)(buf[7] & 0xFF);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        ToSend m = AuthFastLeaderElection.this.sendqueue.take();
                        this.process(m);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="tryAcquire result not chacked, but it is not an issue")
            private void process(ToSend m) {
                int attempts = 0;
                byte[] requestBytes = new byte[48];
                DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
                ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
                switch (m.type) {
                    case 0: {
                        requestBuffer.clear();
                        requestBuffer.putInt(ToSend.mType.crequest.ordinal());
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        byte[] zeroes = new byte[32];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            if (Messenger.this.challengeMap.get(m.tag) != null) break;
                            Messenger.this.mySocket.send(requestPacket);
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending challenge: ", e);
                        }
                        break;
                    }
                    case 1: {
                        ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(m.addr);
                        if (tmpMap != null) {
                            Long tmpLong = tmpMap.get(m.tag);
                            long newChallenge = tmpLong != null ? tmpLong.longValue() : this.genChallenge();
                            tmpMap.put(m.tag, newChallenge);
                            requestBuffer.clear();
                            requestBuffer.putInt(ToSend.mType.challenge.ordinal());
                            requestBuffer.putLong(m.tag);
                            requestBuffer.putInt(m.state.ordinal());
                            requestBuffer.putLong(newChallenge);
                            byte[] zeroes = new byte[24];
                            requestBuffer.put(zeroes);
                            requestPacket.setLength(48);
                            try {
                                requestPacket.setSocketAddress(m.addr);
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                            }
                            try {
                                Messenger.this.mySocket.send(requestPacket);
                            }
                            catch (IOException e) {
                                LOG.warn("Exception while sending challenge: ", e);
                            }
                            break;
                        }
                        LOG.error("Address is not in the configuration: " + m.addr);
                        break;
                    }
                    case 2: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        byte[] zeroes = new byte[8];
                        requestBuffer.put(zeroes);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        boolean myChallenge = false;
                        boolean myAck = false;
                        while (attempts < this.maxAttempts) {
                            try {
                                if (!myChallenge && AuthFastLeaderElection.this.authEnabled) {
                                    ToSend crequest = new ToSend(ToSend.mType.crequest, m.tag, m.leader, m.zxid, m.epoch, QuorumPeer.ServerState.LOOKING, m.addr);
                                    AuthFastLeaderElection.this.sendqueue.offer(crequest);
                                    try {
                                        double timeout2 = (double)this.ackWait * Math.pow(2.0, attempts);
                                        Semaphore s2 = new Semaphore(0);
                                        Messenger messenger = Messenger.this;
                                        synchronized (messenger) {
                                            Messenger.this.challengeMutex.put(m.tag, s2);
                                            s2.tryAcquire((long)timeout2, TimeUnit.MILLISECONDS);
                                            myChallenge = Messenger.this.challengeMap.containsKey(m.tag);
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        LOG.warn("Challenge request exception: ", e);
                                    }
                                }
                                if (AuthFastLeaderElection.this.authEnabled && !myChallenge) {
                                    ++attempts;
                                    continue;
                                }
                                if (AuthFastLeaderElection.this.authEnabled) {
                                    requestBuffer.position(40);
                                    Long tmpLong = Messenger.this.challengeMap.get(m.tag);
                                    if (tmpLong != null) {
                                        requestBuffer.putLong(tmpLong);
                                    } else {
                                        LOG.warn("No challenge with tag: " + m.tag);
                                    }
                                }
                                Messenger.this.mySocket.send(requestPacket);
                                try {
                                    Semaphore s3 = new Semaphore(0);
                                    double timeout3 = (double)this.ackWait * Math.pow(10.0, attempts);
                                    Messenger.this.ackMutex.put(m.tag, s3);
                                    s3.tryAcquire((int)timeout3, TimeUnit.MILLISECONDS);
                                }
                                catch (InterruptedException e) {
                                    LOG.warn("Ack exception: ", e);
                                }
                                if (Messenger.this.ackset.remove(m.tag)) {
                                    myAck = true;
                                }
                            }
                            catch (IOException e) {
                                LOG.warn("Sending exception: ", e);
                            }
                            if (myAck) {
                                Messenger.this.challengeMap.remove(m.tag);
                                return;
                            }
                            ++attempts;
                        }
                        if (m.epoch != AuthFastLeaderElection.this.logicalclock.get()) break;
                        Messenger.this.challengeMap.remove(m.tag);
                        AuthFastLeaderElection.this.sendqueue.offer(m);
                        break;
                    }
                    case 3: {
                        requestBuffer.clear();
                        requestBuffer.putInt(m.type);
                        requestBuffer.putLong(m.tag);
                        requestBuffer.putInt(m.state.ordinal());
                        requestBuffer.putLong(m.leader);
                        requestBuffer.putLong(m.zxid);
                        requestBuffer.putLong(m.epoch);
                        requestPacket.setLength(48);
                        try {
                            requestPacket.setSocketAddress(m.addr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + m.addr, e);
                        }
                        try {
                            Messenger.this.mySocket.send(requestPacket);
                        }
                        catch (IOException e) {
                            LOG.warn("Exception while sending ack: ", e);
                        }
                        break;
                    }
                    default: {
                        LOG.warn("unknown type " + m.type);
                    }
                }
            }
        }

        class WorkerReceiver
        extends ZooKeeperThread {
            DatagramSocket mySocket;
            Messenger myMsg;

            WorkerReceiver(DatagramSocket s2, Messenger msg) {
                super("WorkerReceiver-" + s2.getRemoteSocketAddress());
                this.mySocket = s2;
                this.myMsg = msg;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean saveChallenge(long tag2, long challenge) {
                Semaphore s2 = Messenger.this.challengeMutex.get(tag2);
                if (s2 != null) {
                    Messenger messenger = Messenger.this;
                    synchronized (messenger) {
                        Messenger.this.challengeMap.put(tag2, challenge);
                        Messenger.this.challengeMutex.remove(tag2);
                    }
                    s2.release();
                } else {
                    LOG.error("No challenge mutex object");
                }
                return true;
            }

            @Override
            public void run() {
                byte[] responseBytes = new byte[48];
                ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
                DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
                block13: while (true) {
                    try {
                        responseBuffer.clear();
                        this.mySocket.receive(responsePacket);
                    }
                    catch (IOException e) {
                        LOG.warn("Ignoring exception receiving", e);
                    }
                    if (responsePacket.getLength() != responseBytes.length) {
                        LOG.warn("Got a short response: " + responsePacket.getLength() + " " + responsePacket.toString());
                        continue;
                    }
                    responseBuffer.clear();
                    int type2 = responseBuffer.getInt();
                    if (type2 > 3 || type2 < 0) {
                        LOG.warn("Got bad Msg type: " + type2);
                        continue;
                    }
                    long tag2 = responseBuffer.getLong();
                    QuorumPeer.ServerState ackstate = QuorumPeer.ServerState.LOOKING;
                    switch (responseBuffer.getInt()) {
                        case 0: {
                            ackstate = QuorumPeer.ServerState.LOOKING;
                            break;
                        }
                        case 1: {
                            ackstate = QuorumPeer.ServerState.LEADING;
                            break;
                        }
                        case 2: {
                            ackstate = QuorumPeer.ServerState.FOLLOWING;
                            break;
                        }
                        default: {
                            LOG.warn("unknown type " + responseBuffer.getInt());
                        }
                    }
                    Vote current2 = AuthFastLeaderElection.this.self.getCurrentVote();
                    switch (type2) {
                        case 0: {
                            ToSend c = new ToSend(ToSend.mType.challenge, tag2, current2.getId(), current2.getZxid(), AuthFastLeaderElection.this.logicalclock.get(), AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(c);
                            break;
                        }
                        case 1: {
                            long challenge = responseBuffer.getLong();
                            this.saveChallenge(tag2, challenge);
                            break;
                        }
                        case 2: {
                            Notification n = new Notification();
                            n.leader = responseBuffer.getLong();
                            n.zxid = responseBuffer.getLong();
                            n.epoch = responseBuffer.getLong();
                            n.state = ackstate;
                            n.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (this.myMsg.lastEpoch <= n.epoch && (n.zxid > this.myMsg.lastProposedZxid || n.zxid == this.myMsg.lastProposedZxid && n.leader > this.myMsg.lastProposedLeader)) {
                                this.myMsg.lastProposedZxid = n.zxid;
                                this.myMsg.lastProposedLeader = n.leader;
                                this.myMsg.lastEpoch = n.epoch;
                            }
                            InetSocketAddress addr2 = (InetSocketAddress)responsePacket.getSocketAddress();
                            if (AuthFastLeaderElection.this.authEnabled) {
                                ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(addr2);
                                if (tmpMap == null) continue block13;
                                if (tmpMap.get(tag2) != null) {
                                    long recChallenge = responseBuffer.getLong();
                                    if (tmpMap.get(tag2) == recChallenge) {
                                        AuthFastLeaderElection.this.recvqueue.offer(n);
                                        ToSend a = new ToSend(ToSend.mType.ack, tag2, current2.getId(), current2.getZxid(), AuthFastLeaderElection.this.logicalclock.get(), AuthFastLeaderElection.this.self.getPeerState(), addr2);
                                        AuthFastLeaderElection.this.sendqueue.offer(a);
                                        break;
                                    }
                                    LOG.warn("Incorrect challenge: " + recChallenge + ", " + Messenger.this.addrChallengeMap.toString());
                                    break;
                                }
                                LOG.warn("No challenge for host: " + addr2 + " " + tag2);
                                break;
                            }
                            AuthFastLeaderElection.this.recvqueue.offer(n);
                            ToSend a = new ToSend(ToSend.mType.ack, tag2, current2.getId(), current2.getZxid(), AuthFastLeaderElection.this.logicalclock.get(), AuthFastLeaderElection.this.self.getPeerState(), (InetSocketAddress)responsePacket.getSocketAddress());
                            AuthFastLeaderElection.this.sendqueue.offer(a);
                            break;
                        }
                        case 3: {
                            Semaphore s2 = Messenger.this.ackMutex.get(tag2);
                            if (s2 != null) {
                                s2.release();
                            } else {
                                LOG.error("Empty ack semaphore");
                            }
                            Messenger.this.ackset.add(tag2);
                            if (AuthFastLeaderElection.this.authEnabled) {
                                ConcurrentHashMap<Long, Long> tmpMap = Messenger.this.addrChallengeMap.get(responsePacket.getSocketAddress());
                                if (tmpMap != null) {
                                    tmpMap.remove(tag2);
                                } else {
                                    LOG.warn("No such address in the ensemble configuration " + responsePacket.getSocketAddress());
                                }
                            }
                            if (ackstate == QuorumPeer.ServerState.LOOKING) continue block13;
                            Notification outofsync = new Notification();
                            outofsync.leader = responseBuffer.getLong();
                            outofsync.zxid = responseBuffer.getLong();
                            outofsync.epoch = responseBuffer.getLong();
                            outofsync.state = ackstate;
                            outofsync.addr = (InetSocketAddress)responsePacket.getSocketAddress();
                            AuthFastLeaderElection.this.recvqueue.offer(outofsync);
                            break;
                        }
                        default: {
                            LOG.warn("Received message of incorrect type " + type2);
                        }
                    }
                }
            }
        }
    }

    public static class ToSend {
        int type;
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        long tag;
        InetSocketAddress addr;

        ToSend(mType type2, long tag2, long leader, long zxid, long epoch, QuorumPeer.ServerState state, InetSocketAddress addr2) {
            switch (type2) {
                case crequest: {
                    this.type = 0;
                    this.tag = tag2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr2;
                    break;
                }
                case challenge: {
                    this.type = 1;
                    this.tag = tag2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr2;
                    break;
                }
                case notification: {
                    this.type = 2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = QuorumPeer.ServerState.LOOKING;
                    this.tag = tag2;
                    this.addr = addr2;
                    break;
                }
                case ack: {
                    this.type = 3;
                    this.tag = tag2;
                    this.leader = leader;
                    this.zxid = zxid;
                    this.epoch = epoch;
                    this.state = state;
                    this.addr = addr2;
                    break;
                }
            }
        }

        static enum mType {
            crequest,
            challenge,
            notification,
            ack;

        }
    }

    public static class Notification {
        long leader;
        long zxid;
        long epoch;
        QuorumPeer.ServerState state;
        InetSocketAddress addr;
    }
}

