/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

public enum KeyStoreFileType {
    JKS(".jks"),
    PEM(".pem"),
    PKCS12(".p12");

    private final String defaultFileExtension;

    private KeyStoreFileType(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
    }

    public String getPropertyValue() {
        return this.name();
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public static KeyStoreFileType fromPropertyValue(String propertyValue) {
        if (propertyValue == null || propertyValue.length() == 0) {
            return null;
        }
        return KeyStoreFileType.valueOf(propertyValue.toUpperCase());
    }

    public static KeyStoreFileType fromFilename(String filename2) {
        int i2 = filename2.lastIndexOf(46);
        if (i2 >= 0) {
            String extension = filename2.substring(i2);
            for (KeyStoreFileType storeFileType : KeyStoreFileType.values()) {
                if (!storeFileType.getDefaultFileExtension().equals(extension)) continue;
                return storeFileType;
            }
        }
        throw new IllegalArgumentException("Unable to auto-detect store file type from file name: " + filename2);
    }

    public static KeyStoreFileType fromPropertyValueOrFileName(String propertyValue, String filename2) {
        KeyStoreFileType result2 = KeyStoreFileType.fromPropertyValue(propertyValue);
        if (result2 == null) {
            result2 = KeyStoreFileType.fromFilename(filename2);
        }
        return result2;
    }
}

