/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.EphemeralType;

public abstract class Op {
    private int type;
    private String path;

    private Op(int type2, String path2) {
        this.type = type2;
        this.path = path2;
    }

    public static Op create(String path2, byte[] data, List<ACL> acl, int flags) {
        return new Create(path2, data, acl, flags);
    }

    public static Op create(String path2, byte[] data, List<ACL> acl, int flags, long ttl) {
        CreateMode createMode = CreateMode.fromFlag(flags, CreateMode.PERSISTENT);
        if (createMode.isTTL()) {
            return new CreateTTL(path2, data, acl, createMode, ttl);
        }
        return new Create(path2, data, acl, flags);
    }

    public static Op create(String path2, byte[] data, List<ACL> acl, CreateMode createMode) {
        return new Create(path2, data, acl, createMode);
    }

    public static Op create(String path2, byte[] data, List<ACL> acl, CreateMode createMode, long ttl) {
        if (createMode.isTTL()) {
            return new CreateTTL(path2, data, acl, createMode, ttl);
        }
        return new Create(path2, data, acl, createMode);
    }

    public static Op delete(String path2, int version) {
        return new Delete(path2, version);
    }

    public static Op setData(String path2, byte[] data, int version) {
        return new SetData(path2, data, version);
    }

    public static Op check(String path2, int version) {
        return new Check(path2, version);
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public abstract Record toRequestRecord();

    abstract Op withChroot(String var1);

    void validate() throws KeeperException {
        PathUtils.validatePath(this.path);
    }

    public static class Check
    extends Op {
        private int version;

        private Check(String path2, int version) {
            super(13, path2);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Check)) {
                return false;
            }
            Check op = (Check)o;
            return this.getType() == op.getType() && this.getPath().equals(op.getPath()) && this.version == op.version;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new CheckVersionRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String path2) {
            return new Check(path2, this.version);
        }
    }

    public static class SetData
    extends Op {
        private byte[] data;
        private int version;

        private SetData(String path2, byte[] data, int version) {
            super(5, path2);
            this.data = data;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetData)) {
                return false;
            }
            SetData op = (SetData)o;
            return this.getType() == op.getType() && this.version == op.version && this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data) + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new SetDataRequest(this.getPath(), this.data, this.version);
        }

        @Override
        Op withChroot(String path2) {
            return new SetData(path2, this.data, this.version);
        }
    }

    public static class Delete
    extends Op {
        private int version;

        private Delete(String path2, int version) {
            super(2, path2);
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete op = (Delete)o;
            return this.getType() == op.getType() && this.version == op.version && this.getPath().equals(op.getPath());
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + this.version;
        }

        @Override
        public Record toRequestRecord() {
            return new DeleteRequest(this.getPath(), this.version);
        }

        @Override
        Op withChroot(String path2) {
            return new Delete(path2, this.version);
        }
    }

    public static class CreateTTL
    extends Create {
        private final long ttl;

        private CreateTTL(String path2, byte[] data, List<ACL> acl, int flags, long ttl) {
            super(path2, data, acl, flags);
            this.ttl = ttl;
        }

        private CreateTTL(String path2, byte[] data, List<ACL> acl, CreateMode createMode, long ttl) {
            super(path2, data, acl, createMode);
            this.ttl = ttl;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && o instanceof CreateTTL && this.ttl == ((CreateTTL)o).ttl;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (int)(this.ttl ^ this.ttl >>> 32);
        }

        @Override
        public Record toRequestRecord() {
            return new CreateTTLRequest(this.getPath(), this.data, this.acl, this.flags, this.ttl);
        }

        @Override
        Op withChroot(String path2) {
            return new CreateTTL(path2, this.data, (List<ACL>)this.acl, this.flags, this.ttl);
        }

        @Override
        void validate() throws KeeperException {
            CreateMode createMode = CreateMode.fromFlag(this.flags);
            PathUtils.validatePath(this.getPath(), createMode.isSequential());
            EphemeralType.validateTTL(createMode, this.ttl);
        }
    }

    public static class Create
    extends Op {
        protected byte[] data;
        protected List<ACL> acl;
        protected int flags;

        private Create(String path2, byte[] data, List<ACL> acl, int flags) {
            super(Create.getOpcode(CreateMode.fromFlag(flags, CreateMode.PERSISTENT)), path2);
            this.data = data;
            this.acl = acl;
            this.flags = flags;
        }

        private static int getOpcode(CreateMode createMode) {
            if (createMode.isTTL()) {
                return 21;
            }
            return createMode.isContainer() ? 19 : 1;
        }

        private Create(String path2, byte[] data, List<ACL> acl, CreateMode createMode) {
            super(Create.getOpcode(createMode), path2);
            this.data = data;
            this.acl = acl;
            this.flags = createMode.toFlag();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Create)) {
                return false;
            }
            Create op = (Create)o;
            boolean aclEquals = true;
            Iterator<ACL> i2 = op.acl.iterator();
            for (ACL acl : op.acl) {
                boolean hasMoreData = i2.hasNext();
                if (!hasMoreData) {
                    aclEquals = false;
                    break;
                }
                ACL otherAcl = i2.next();
                if (acl.equals(otherAcl)) continue;
                aclEquals = false;
                break;
            }
            return !i2.hasNext() && this.getType() == op.getType() && Arrays.equals(this.data, op.data) && this.flags == op.flags && aclEquals;
        }

        public int hashCode() {
            return this.getType() + this.getPath().hashCode() + Arrays.hashCode(this.data);
        }

        @Override
        public Record toRequestRecord() {
            return new CreateRequest(this.getPath(), this.data, this.acl, this.flags);
        }

        @Override
        Op withChroot(String path2) {
            return new Create(path2, this.data, this.acl, this.flags);
        }

        @Override
        void validate() throws KeeperException {
            CreateMode createMode = CreateMode.fromFlag(this.flags);
            PathUtils.validatePath(this.getPath(), createMode.isSequential());
            EphemeralType.validateTTL(createMode, -1L);
        }
    }
}

