/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.proto.Create2Response;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ErrorResponse;
import org.apache.zookeeper.proto.MultiHeader;
import org.apache.zookeeper.proto.SetDataResponse;

public class MultiResponse
implements Record,
Iterable<OpResult> {
    private List<OpResult> results = new ArrayList<OpResult>();

    public void add(OpResult x) {
        this.results.add(x);
    }

    @Override
    public Iterator<OpResult> iterator() {
        return this.results.iterator();
    }

    public int size() {
        return this.results.size();
    }

    @Override
    public void serialize(OutputArchive archive, String tag2) throws IOException {
        archive.startRecord(this, tag2);
        block7: for (OpResult result2 : this.results) {
            int err = result2.getType() == -1 ? ((OpResult.ErrorResult)result2).getErr() : 0;
            new MultiHeader(result2.getType(), false, err).serialize(archive, tag2);
            switch (result2.getType()) {
                case 1: {
                    new CreateResponse(((OpResult.CreateResult)result2).getPath()).serialize(archive, tag2);
                    continue block7;
                }
                case 15: {
                    OpResult.CreateResult createResult = (OpResult.CreateResult)result2;
                    new Create2Response(createResult.getPath(), createResult.getStat()).serialize(archive, tag2);
                    continue block7;
                }
                case 2: 
                case 13: {
                    continue block7;
                }
                case 5: {
                    new SetDataResponse(((OpResult.SetDataResult)result2).getStat()).serialize(archive, tag2);
                    continue block7;
                }
                case -1: {
                    new ErrorResponse(((OpResult.ErrorResult)result2).getErr()).serialize(archive, tag2);
                    continue block7;
                }
            }
            throw new IOException("Invalid type " + result2.getType() + " in MultiResponse");
        }
        new MultiHeader(-1, true, -1).serialize(archive, tag2);
        archive.endRecord(this, tag2);
    }

    @Override
    public void deserialize(InputArchive archive, String tag2) throws IOException {
        this.results = new ArrayList<OpResult>();
        archive.startRecord(tag2);
        MultiHeader h = new MultiHeader();
        h.deserialize(archive, tag2);
        while (!h.getDone()) {
            switch (h.getType()) {
                case 1: {
                    CreateResponse cr = new CreateResponse();
                    cr.deserialize(archive, tag2);
                    this.results.add(new OpResult.CreateResult(cr.getPath()));
                    break;
                }
                case 15: {
                    Create2Response cr2 = new Create2Response();
                    cr2.deserialize(archive, tag2);
                    this.results.add(new OpResult.CreateResult(cr2.getPath(), cr2.getStat()));
                    break;
                }
                case 2: {
                    this.results.add(new OpResult.DeleteResult());
                    break;
                }
                case 5: {
                    SetDataResponse sdr = new SetDataResponse();
                    sdr.deserialize(archive, tag2);
                    this.results.add(new OpResult.SetDataResult(sdr.getStat()));
                    break;
                }
                case 13: {
                    this.results.add(new OpResult.CheckResult());
                    break;
                }
                case -1: {
                    ErrorResponse er = new ErrorResponse();
                    er.deserialize(archive, tag2);
                    this.results.add(new OpResult.ErrorResult(er.getErr()));
                    break;
                }
                default: {
                    throw new IOException("Invalid type " + h.getType() + " in MultiResponse");
                }
            }
            h.deserialize(archive, tag2);
        }
        archive.endRecord(tag2);
    }

    public List<OpResult> getResultList() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiResponse)) {
            return false;
        }
        MultiResponse other = (MultiResponse)o;
        if (this.results != null) {
            Iterator<OpResult> i2 = other.results.iterator();
            for (OpResult result2 : this.results) {
                if (i2.hasNext()) {
                    if (result2.equals(i2.next())) continue;
                    return false;
                }
                return false;
            }
            return !i2.hasNext();
        }
        return other.results == null;
    }

    public int hashCode() {
        int hash2 = this.results.size();
        for (OpResult result2 : this.results) {
            hash2 = hash2 * 35 + result2.hashCode();
        }
        return hash2;
    }
}

