/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TreeMap;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.Utils;

public class CsvOutputArchive
implements OutputArchive {
    private PrintStream stream;
    private boolean isFirst = true;

    static CsvOutputArchive getArchive(OutputStream strm) throws UnsupportedEncodingException {
        return new CsvOutputArchive(strm);
    }

    private void throwExceptionOnError(String tag2) throws IOException {
        if (this.stream.checkError()) {
            throw new IOException("Error serializing " + tag2);
        }
    }

    private void printCommaUnlessFirst() {
        if (!this.isFirst) {
            this.stream.print(",");
        }
        this.isFirst = false;
    }

    public CsvOutputArchive(OutputStream out) throws UnsupportedEncodingException {
        this.stream = new PrintStream(out, true, "UTF-8");
    }

    @Override
    public void writeByte(byte b, String tag2) throws IOException {
        this.writeLong(b, tag2);
    }

    @Override
    public void writeBool(boolean b, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        String val = b ? "T" : "F";
        this.stream.print(val);
        this.throwExceptionOnError(tag2);
    }

    @Override
    public void writeInt(int i2, String tag2) throws IOException {
        this.writeLong(i2, tag2);
    }

    @Override
    public void writeLong(long l, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(l);
        this.throwExceptionOnError(tag2);
    }

    @Override
    public void writeFloat(float f, String tag2) throws IOException {
        this.writeDouble(f, tag2);
    }

    @Override
    public void writeDouble(double d, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(d);
        this.throwExceptionOnError(tag2);
    }

    @Override
    public void writeString(String s2, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVString(s2));
        this.throwExceptionOnError(tag2);
    }

    @Override
    public void writeBuffer(byte[] buf, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print(Utils.toCSVBuffer(buf));
        this.throwExceptionOnError(tag2);
    }

    @Override
    public void writeRecord(Record r, String tag2) throws IOException {
        if (r == null) {
            return;
        }
        r.serialize(this, tag2);
    }

    @Override
    public void startRecord(Record r, String tag2) throws IOException {
        if (tag2 != null && !"".equals(tag2)) {
            this.printCommaUnlessFirst();
            this.stream.print("s{");
            this.isFirst = true;
        }
    }

    @Override
    public void endRecord(Record r, String tag2) throws IOException {
        if (tag2 == null || "".equals(tag2)) {
            this.stream.print("\n");
            this.isFirst = true;
        } else {
            this.stream.print("}");
            this.isFirst = false;
        }
    }

    @Override
    public void startVector(List<?> v, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("v{");
        this.isFirst = true;
    }

    @Override
    public void endVector(List<?> v, String tag2) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }

    @Override
    public void startMap(TreeMap<?, ?> v, String tag2) throws IOException {
        this.printCommaUnlessFirst();
        this.stream.print("m{");
        this.isFirst = true;
    }

    @Override
    public void endMap(TreeMap<?, ?> v, String tag2) throws IOException {
        this.stream.print("}");
        this.isFirst = false;
    }
}

