/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.BigIntegerNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.BinaryNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.BooleanNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.DecimalNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.DoubleNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.FloatNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.IntNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.JsonNodeCreator;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.LongNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.NullNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.NumericNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.POJONode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.ShortNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.TextNode;
import org.apache.htrace.shaded.fasterxml.jackson.databind.node.ValueNode;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = -3271940633258788634L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bigDecimalExact) {
        return bigDecimalExact ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Byte value2) {
        return value2 == null ? this.nullNode() : IntNode.valueOf(value2.intValue());
    }

    @Override
    public NumericNode numberNode(short v) {
        return ShortNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Short value2) {
        return value2 == null ? this.nullNode() : ShortNode.valueOf(value2);
    }

    @Override
    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Integer value2) {
        return value2 == null ? this.nullNode() : IntNode.valueOf(value2);
    }

    @Override
    public NumericNode numberNode(long v) {
        if (this._inIntRange(v)) {
            return IntNode.valueOf((int)v);
        }
        return LongNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Long value2) {
        if (value2 == null) {
            return this.nullNode();
        }
        long l = value2;
        return this._inIntRange(l) ? IntNode.valueOf((int)l) : LongNode.valueOf(l);
    }

    @Override
    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    @Override
    public NumericNode numberNode(float v) {
        return FloatNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Float value2) {
        return value2 == null ? this.nullNode() : FloatNode.valueOf(value2.floatValue());
    }

    @Override
    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Double value2) {
        return value2 == null ? this.nullNode() : DoubleNode.valueOf(value2);
    }

    @Override
    public NumericNode numberNode(BigDecimal v) {
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(v);
        }
        return v.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(v.stripTrailingZeros());
    }

    @Override
    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    @Override
    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    @Override
    public BinaryNode binaryNode(byte[] data, int offset2, int length2) {
        return BinaryNode.valueOf(data, offset2, length2);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object pojo) {
        return new POJONode(pojo);
    }

    @Deprecated
    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }

    protected boolean _inIntRange(long l) {
        int i2 = (int)l;
        long l2 = i2;
        return l2 == l;
    }
}

