/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.commons.logging.impl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.htrace.shaded.commons.logging.Log;

public class Jdk14Logger
implements Log,
Serializable {
    protected static final Level dummyLevel = Level.FINE;
    protected transient Logger logger = null;
    protected String name = null;

    public Jdk14Logger(String name2) {
        this.name = name2;
        this.logger = this.getLogger();
    }

    private void log(Level level2, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level2)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method2 = "unknown";
            if (locations != null && locations.length > 2) {
                StackTraceElement caller2 = locations[2];
                cname = caller2.getClassName();
                method2 = caller2.getMethodName();
            }
            if (ex == null) {
                logger.logp(level2, cname, method2, msg);
            } else {
                logger.logp(level2, cname, method2, msg, ex);
            }
        }
    }

    public void debug(Object message2) {
        this.log(Level.FINE, String.valueOf(message2), null);
    }

    public void debug(Object message2, Throwable exception2) {
        this.log(Level.FINE, String.valueOf(message2), exception2);
    }

    public void error(Object message2) {
        this.log(Level.SEVERE, String.valueOf(message2), null);
    }

    public void error(Object message2, Throwable exception2) {
        this.log(Level.SEVERE, String.valueOf(message2), exception2);
    }

    public void fatal(Object message2) {
        this.log(Level.SEVERE, String.valueOf(message2), null);
    }

    public void fatal(Object message2, Throwable exception2) {
        this.log(Level.SEVERE, String.valueOf(message2), exception2);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    public void info(Object message2) {
        this.log(Level.INFO, String.valueOf(message2), null);
    }

    public void info(Object message2, Throwable exception2) {
        this.log(Level.INFO, String.valueOf(message2), exception2);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void trace(Object message2) {
        this.log(Level.FINEST, String.valueOf(message2), null);
    }

    public void trace(Object message2, Throwable exception2) {
        this.log(Level.FINEST, String.valueOf(message2), exception2);
    }

    public void warn(Object message2) {
        this.log(Level.WARNING, String.valueOf(message2), null);
    }

    public void warn(Object message2, Throwable exception2) {
        this.log(Level.WARNING, String.valueOf(message2), exception2);
    }
}

