/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.impl.NoOpLog;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    public static void setLogImplementation(String classname) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> logclass = Class.forName(classname);
            Class[] argtypes = new Class[]{"".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable t) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static Log getInstance(String name2) {
        Log log3 = (Log)logs.get(name2);
        if (null == log3) {
            log3 = LogSource.makeNewLogInstance(name2);
            logs.put(name2, log3);
        }
        return log3;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name2) {
        Log log3 = null;
        try {
            Object[] args2 = new Object[]{name2};
            log3 = (Log)logImplctor.newInstance(args2);
        }
        catch (Throwable t) {
            log3 = null;
        }
        if (null == log3) {
            log3 = new NoOpLog(name2);
        }
        return log3;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    static {
        try {
            log4jIsAvailable = null != Class.forName("org.apache.log4j.Logger");
        }
        catch (Throwable t) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("java.util.logging.Logger") && null != Class.forName("org.apache.htrace.shaded.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable t) {
            jdk14IsAvailable = false;
        }
        String name2 = null;
        try {
            name2 = System.getProperty("org.apache.htrace.shaded.commons.logging.log");
            if (name2 == null) {
                name2 = System.getProperty("org.apache.htrace.shaded.commons.logging.Log");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (name2 != null) {
            try {
                LogSource.setLogImplementation(name2);
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation("org.apache.htrace.shaded.commons.logging.impl.NoOpLog");
                }
                catch (Throwable u) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("org.apache.htrace.shaded.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("org.apache.htrace.shaded.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("org.apache.htrace.shaded.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable t) {
                try {
                    LogSource.setLogImplementation("org.apache.htrace.shaded.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

