/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.Tracer;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;

public class TracerPool {
    private static final Log LOG = LogFactory.getLog(TracerPool.class);
    static final TracerPool GLOBAL = new TracerPool("Global");
    private final String name;
    private volatile SpanReceiver[] curReceivers;
    private SpanReceiverShutdownHook shutdownHook;
    private final HashSet<Tracer> curTracers;

    public static TracerPool getGlobalTracerPool() {
        return GLOBAL;
    }

    public TracerPool(String name2) {
        this.name = name2;
        this.shutdownHook = null;
        this.curTracers = new HashSet();
        this.curReceivers = new SpanReceiver[0];
    }

    public String getName() {
        return this.name;
    }

    public SpanReceiver[] getReceivers() {
        return this.curReceivers;
    }

    public synchronized boolean addReceiver(SpanReceiver receiver2) {
        SpanReceiver[] receivers = this.curReceivers;
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            if (receivers[i2] != receiver2) continue;
            LOG.trace(this.toString() + ": can't add receiver " + receiver2.toString() + " since it is already in this pool.");
            return false;
        }
        SpanReceiver[] newReceivers = Arrays.copyOf(receivers, receivers.length + 1);
        newReceivers[receivers.length] = receiver2;
        this.registerShutdownHookIfNeeded();
        this.curReceivers = newReceivers;
        LOG.trace(this.toString() + ": added receiver " + receiver2.toString());
        return true;
    }

    private synchronized void registerShutdownHookIfNeeded() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new SpanReceiverShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        LOG.trace(this.toString() + ": registered shutdown hook.");
    }

    public synchronized boolean removeReceiver(SpanReceiver receiver2) {
        SpanReceiver[] receivers = this.curReceivers;
        for (int i2 = 0; i2 < receivers.length; ++i2) {
            if (receivers[i2] != receiver2) continue;
            SpanReceiver[] newReceivers = new SpanReceiver[receivers.length - 1];
            System.arraycopy(receivers, 0, newReceivers, 0, i2);
            System.arraycopy(receivers, i2 + 1, newReceivers, i2, receivers.length - i2 - 1);
            this.curReceivers = newReceivers;
            LOG.trace(this.toString() + ": removed receiver " + receiver2.toString());
            return true;
        }
        LOG.trace(this.toString() + ": can't remove receiver " + receiver2.toString() + " since it's not currently in this pool.");
        return false;
    }

    public boolean removeAndCloseReceiver(SpanReceiver receiver2) {
        if (!this.removeReceiver(receiver2)) {
            return false;
        }
        try {
            LOG.trace(this.toString() + ": closing receiver " + receiver2.toString());
            receiver2.close();
        }
        catch (Throwable t) {
            LOG.error(this.toString() + ": error closing " + receiver2.toString(), t);
        }
        return true;
    }

    private synchronized void removeAndCloseAllSpanReceivers() {
        SpanReceiver[] receivers = this.curReceivers;
        this.curReceivers = new SpanReceiver[0];
        for (SpanReceiver receiver2 : receivers) {
            try {
                LOG.trace(this.toString() + ": closing receiver " + receiver2.toString());
                receiver2.close();
            }
            catch (Throwable t) {
                LOG.error(this.toString() + ": error closing " + receiver2.toString(), t);
            }
        }
    }

    public synchronized SpanReceiver loadReceiverType(String className, HTraceConfiguration conf, ClassLoader classLoader) {
        SpanReceiver[] receivers;
        String receiverClass = className.contains(".") ? className : "org.apache.htrace.core." + className;
        for (SpanReceiver receiver2 : receivers = this.curReceivers) {
            if (!receiver2.getClass().getName().equals(receiverClass)) continue;
            LOG.trace(this.toString() + ": returning a reference to receiver " + receiver2.toString());
            return receiver2;
        }
        LOG.trace(this.toString() + ": creating a new SpanReceiver of type " + className);
        SpanReceiver receiver3 = new SpanReceiver.Builder(conf).className(className).classLoader(classLoader).build();
        this.addReceiver(receiver3);
        return receiver3;
    }

    public synchronized Tracer[] getTracers() {
        return this.curTracers.toArray(new Tracer[this.curTracers.size()]);
    }

    synchronized void addTracer(Tracer tracer) {
        if (this.curTracers.add(tracer)) {
            LOG.trace(this.toString() + ": adding tracer " + tracer.toString());
        }
    }

    synchronized void removeTracer(Tracer tracer) {
        if (this.curTracers.remove(tracer)) {
            LOG.trace(this.toString() + ": removing tracer " + tracer.toString());
            if (this.curTracers.size() == 0) {
                this.removeAndCloseAllSpanReceivers();
            }
        }
    }

    public String toString() {
        return "TracerPool(" + this.name + ")";
    }

    private class SpanReceiverShutdownHook
    extends Thread {
        SpanReceiverShutdownHook() {
            this.setName("SpanReceiverShutdownHook");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            TracerPool.this.removeAndCloseAllSpanReceivers();
        }
    }
}

