/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.apache.commons.collections4.multimap;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.ListUtils;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.ListValuedMap;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.multimap.AbstractMultiValuedMap;

public abstract class AbstractListValuedMap<K, V>
extends AbstractMultiValuedMap<K, V>
implements ListValuedMap<K, V> {
    protected AbstractListValuedMap() {
    }

    protected AbstractListValuedMap(Map<K, ? extends List<V>> map) {
        super(map);
    }

    @Override
    protected Map<K, List<V>> getMap() {
        return super.getMap();
    }

    @Override
    protected abstract List<V> createCollection();

    @Override
    public List<V> get(K key2) {
        return this.wrappedCollection((Object)key2);
    }

    @Override
    List<V> wrappedCollection(K key2) {
        return new WrappedList(key2);
    }

    @Override
    public List<V> remove(Object key2) {
        return ListUtils.emptyIfNull(this.getMap().remove(key2));
    }

    private class ValuesListIterator
    implements ListIterator<V> {
        private final K key;
        private List<V> values;
        private ListIterator<V> iterator;

        public ValuesListIterator(K key2) {
            this.key = key2;
            this.values = ListUtils.emptyIfNull(AbstractListValuedMap.this.getMap().get(key2));
            this.iterator = this.values.listIterator();
        }

        public ValuesListIterator(K key2, int index2) {
            this.key = key2;
            this.values = ListUtils.emptyIfNull(AbstractListValuedMap.this.getMap().get(key2));
            this.iterator = this.values.listIterator(index2);
        }

        @Override
        public void add(V value2) {
            if (AbstractListValuedMap.this.getMap().get(this.key) == null) {
                Collection list2 = AbstractListValuedMap.this.createCollection();
                AbstractListValuedMap.this.getMap().put(this.key, (List<Collection>)list2);
                this.values = list2;
                this.iterator = list2.listIterator();
            }
            this.iterator.add(value2);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public V previous() {
            return this.iterator.previous();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                AbstractListValuedMap.this.getMap().remove(this.key);
            }
        }

        @Override
        public void set(V value2) {
            this.iterator.set(value2);
        }
    }

    private class WrappedList
    extends AbstractMultiValuedMap.WrappedCollection
    implements List<V> {
        public WrappedList(K key2) {
            super(AbstractListValuedMap.this, key2);
        }

        protected List<V> getMapping() {
            return AbstractListValuedMap.this.getMap().get(this.key);
        }

        @Override
        public void add(int index2, V value2) {
            Collection list2 = this.getMapping();
            if (list2 == null) {
                list2 = AbstractListValuedMap.this.createCollection();
                AbstractListValuedMap.this.getMap().put(this.key, (List<Collection>)list2);
            }
            list2.add(index2, value2);
        }

        @Override
        public boolean addAll(int index2, Collection<? extends V> c) {
            Collection list2 = this.getMapping();
            if (list2 == null) {
                list2 = AbstractListValuedMap.this.createCollection();
                boolean changed = list2.addAll(index2, c);
                if (changed) {
                    AbstractListValuedMap.this.getMap().put(this.key, (List<Collection>)list2);
                }
                return changed;
            }
            return list2.addAll(index2, c);
        }

        @Override
        public V get(int index2) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            return list2.get(index2);
        }

        @Override
        public int indexOf(Object o) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            return list2.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            return list2.lastIndexOf(o);
        }

        @Override
        public ListIterator<V> listIterator() {
            return new ValuesListIterator(this.key);
        }

        @Override
        public ListIterator<V> listIterator(int index2) {
            return new ValuesListIterator(this.key, index2);
        }

        @Override
        public V remove(int index2) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            Object value2 = list2.remove(index2);
            if (list2.isEmpty()) {
                AbstractListValuedMap.this.remove(this.key);
            }
            return value2;
        }

        @Override
        public V set(int index2, V value2) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            return list2.set(index2, value2);
        }

        @Override
        public List<V> subList(int fromIndex, int toIndex) {
            List list2 = ListUtils.emptyIfNull(this.getMapping());
            return list2.subList(fromIndex, toIndex);
        }

        @Override
        public boolean equals(Object other) {
            Collection list2 = this.getMapping();
            if (list2 == null) {
                return Collections.emptyList().equals(other);
            }
            if (!(other instanceof List)) {
                return false;
            }
            List otherList = (List)other;
            return ListUtils.isEqualList(list2, otherList);
        }

        @Override
        public int hashCode() {
            Collection list2 = this.getMapping();
            return ListUtils.hashCodeForList(list2);
        }
    }
}

