/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.ssl;

import java.util.Locale;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SniCompletionEvent;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslClientHelloHandler;
import org.apache.hbase.thirdparty.io.netty.util.CharsetUtil;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Future;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    private String hostname;

    private static String extractSniHostname(ByteBuf in) {
        int offset2 = in.readerIndex();
        int endOffset = in.writerIndex();
        if (endOffset - (offset2 += 34) >= 6) {
            int extensionsLength;
            int extensionsLimit;
            short sessionIdLength = in.getUnsignedByte(offset2);
            int cipherSuitesLength = in.getUnsignedShort(offset2 += sessionIdLength + 1);
            short compressionMethodLength = in.getUnsignedByte(offset2 += cipherSuitesLength + 2);
            offset2 += compressionMethodLength + 1;
            if ((extensionsLimit = (offset2 += 2) + (extensionsLength = in.getUnsignedShort(offset2))) <= endOffset) {
                while (extensionsLimit - offset2 >= 4) {
                    int extensionLength;
                    int extensionType = in.getUnsignedShort(offset2);
                    offset2 += 2;
                    if (extensionsLimit - (offset2 += 2) < (extensionLength = in.getUnsignedShort(offset2))) break;
                    if (extensionType == 0) {
                        int serverNameLength;
                        if (extensionsLimit - (offset2 += 2) < 3) break;
                        short serverNameType = in.getUnsignedByte(offset2);
                        ++offset2;
                        if (serverNameType != 0 || extensionsLimit - (offset2 += 2) < (serverNameLength = in.getUnsignedShort(offset2))) break;
                        String hostname = in.toString(offset2, serverNameLength, CharsetUtil.US_ASCII);
                        return hostname.toLowerCase(Locale.US);
                    }
                    offset2 += extensionLength;
                }
            }
        }
        return null;
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext ctx, ByteBuf clientHello) throws Exception {
        this.hostname = clientHello == null ? null : AbstractSniHandler.extractSniHostname(clientHello);
        return this.lookup(ctx, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext ctx, Future<T> future) throws Exception {
        try {
            this.onLookupComplete(ctx, this.hostname, future);
        }
        finally {
            AbstractSniHandler.fireSniCompletionEvent(ctx, this.hostname, future);
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2) throws Exception;

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3) throws Exception;

    private static void fireSniCompletionEvent(ChannelHandlerContext ctx, String hostname, Future<?> future) {
        Throwable cause2 = future.cause();
        if (cause2 == null) {
            ctx.fireUserEventTriggered(new SniCompletionEvent(hostname));
        } else {
            ctx.fireUserEventTriggered(new SniCompletionEvent(hostname, cause2));
        }
    }
}

