/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public final class MqttUnsubAckPayload {
    private final List<Short> unsubscribeReasonCodes;
    private static final MqttUnsubAckPayload EMPTY = new MqttUnsubAckPayload(new short[0]);

    public static MqttUnsubAckPayload withEmptyDefaults(MqttUnsubAckPayload payload) {
        if (payload == null) {
            return EMPTY;
        }
        return payload;
    }

    public MqttUnsubAckPayload(short ... unsubscribeReasonCodes) {
        ObjectUtil.checkNotNull(unsubscribeReasonCodes, "unsubscribeReasonCodes");
        ArrayList<Short> list2 = new ArrayList<Short>(unsubscribeReasonCodes.length);
        short[] sArray = unsubscribeReasonCodes;
        int n = sArray.length;
        for (int j = 0; j < n; ++j) {
            Short v = sArray[j];
            list2.add(v);
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list2);
    }

    public MqttUnsubAckPayload(Iterable<Short> unsubscribeReasonCodes) {
        ObjectUtil.checkNotNull(unsubscribeReasonCodes, "unsubscribeReasonCodes");
        ArrayList<Short> list2 = new ArrayList<Short>();
        for (Short v : unsubscribeReasonCodes) {
            ObjectUtil.checkNotNull(v, "unsubscribeReasonCode");
            list2.add(v);
        }
        this.unsubscribeReasonCodes = Collections.unmodifiableList(list2);
    }

    public List<Short> unsubscribeReasonCodes() {
        return this.unsubscribeReasonCodes;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "unsubscribeReasonCodes=" + this.unsubscribeReasonCodes + ']';
    }
}

