/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.marshalling;

import java.io.IOException;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.jboss.marshalling.ByteInput;

class LimitingByteInput
implements ByteInput {
    private static final TooBigObjectException EXCEPTION = new TooBigObjectException();
    private final ByteInput input;
    private final long limit;
    private long read;

    LimitingByteInput(ByteInput input, long limit2) {
        this.input = input;
        this.limit = ObjectUtil.checkPositive(limit2, "limit");
    }

    public void close() throws IOException {
    }

    public int available() throws IOException {
        return this.readable(this.input.available());
    }

    public int read() throws IOException {
        int readable = this.readable(1);
        if (readable > 0) {
            int b = this.input.read();
            ++this.read;
            return b;
        }
        throw EXCEPTION;
    }

    public int read(byte[] array) throws IOException {
        return this.read(array, 0, array.length);
    }

    public int read(byte[] array, int offset2, int length2) throws IOException {
        int readable = this.readable(length2);
        if (readable > 0) {
            int i2 = this.input.read(array, offset2, readable);
            this.read += (long)i2;
            return i2;
        }
        throw EXCEPTION;
    }

    public long skip(long bytes2) throws IOException {
        int readable = this.readable((int)bytes2);
        if (readable > 0) {
            long i2 = this.input.skip((long)readable);
            this.read += i2;
            return i2;
        }
        throw EXCEPTION;
    }

    private int readable(int length2) {
        return (int)Math.min((long)length2, this.limit - this.read);
    }

    static final class TooBigObjectException
    extends IOException {
        private static final long serialVersionUID = 1L;

        TooBigObjectException() {
        }
    }
}

