/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec;

import java.text.ParseException;
import java.util.Date;
import org.apache.hbase.thirdparty.io.netty.handler.codec.DateFormatter;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ValueConverter;
import org.apache.hbase.thirdparty.io.netty.util.AsciiString;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();
    private static final AsciiString TRUE_ASCII = new AsciiString("true");

    @Override
    public CharSequence convertObject(Object value2) {
        if (value2 instanceof CharSequence) {
            return (CharSequence)value2;
        }
        return value2.toString();
    }

    @Override
    public CharSequence convertInt(int value2) {
        return String.valueOf(value2);
    }

    @Override
    public CharSequence convertLong(long value2) {
        return String.valueOf(value2);
    }

    @Override
    public CharSequence convertDouble(double value2) {
        return String.valueOf(value2);
    }

    @Override
    public CharSequence convertChar(char value2) {
        return String.valueOf(value2);
    }

    @Override
    public CharSequence convertBoolean(boolean value2) {
        return String.valueOf(value2);
    }

    @Override
    public CharSequence convertFloat(float value2) {
        return String.valueOf(value2);
    }

    @Override
    public boolean convertToBoolean(CharSequence value2) {
        return AsciiString.contentEqualsIgnoreCase(value2, TRUE_ASCII);
    }

    @Override
    public CharSequence convertByte(byte value2) {
        return String.valueOf(value2);
    }

    @Override
    public byte convertToByte(CharSequence value2) {
        if (value2 instanceof AsciiString && value2.length() == 1) {
            return ((AsciiString)value2).byteAt(0);
        }
        return Byte.parseByte(value2.toString());
    }

    @Override
    public char convertToChar(CharSequence value2) {
        return value2.charAt(0);
    }

    @Override
    public CharSequence convertShort(short value2) {
        return String.valueOf(value2);
    }

    @Override
    public short convertToShort(CharSequence value2) {
        if (value2 instanceof AsciiString) {
            return ((AsciiString)value2).parseShort();
        }
        return Short.parseShort(value2.toString());
    }

    @Override
    public int convertToInt(CharSequence value2) {
        if (value2 instanceof AsciiString) {
            return ((AsciiString)value2).parseInt();
        }
        return Integer.parseInt(value2.toString());
    }

    @Override
    public long convertToLong(CharSequence value2) {
        if (value2 instanceof AsciiString) {
            return ((AsciiString)value2).parseLong();
        }
        return Long.parseLong(value2.toString());
    }

    @Override
    public CharSequence convertTimeMillis(long value2) {
        return DateFormatter.format(new Date(value2));
    }

    @Override
    public long convertToTimeMillis(CharSequence value2) {
        Date date = DateFormatter.parseHttpDate(value2);
        if (date == null) {
            PlatformDependent.throwException(new ParseException("header can't be parsed into a Date: " + value2, 0));
            return 0L;
        }
        return date.getTime();
    }

    @Override
    public float convertToFloat(CharSequence value2) {
        if (value2 instanceof AsciiString) {
            return ((AsciiString)value2).parseFloat();
        }
        return Float.parseFloat(value2.toString());
    }

    @Override
    public double convertToDouble(CharSequence value2) {
        if (value2 instanceof AsciiString) {
            return ((AsciiString)value2).parseDouble();
        }
        return Double.parseDouble(value2.toString());
    }
}

