/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.io.netty.buffer.AbstractByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.SwappedByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.UnpooledDirectByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.UnsafeByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.UnsafeDirectSwappedByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

public class UnpooledUnsafeDirectByteBuf
extends UnpooledDirectByteBuf {
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc2, int initialCapacity, int maxCapacity) {
        super(alloc2, initialCapacity, maxCapacity);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc2, ByteBuffer initialBuffer, int maxCapacity) {
        super(alloc2, initialBuffer, maxCapacity, false, true);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator alloc2, ByteBuffer initialBuffer, int maxCapacity, boolean doFree) {
        super(alloc2, initialBuffer, maxCapacity, doFree, false);
    }

    @Override
    final void setByteBuffer(ByteBuffer buffer, boolean tryFree) {
        super.setByteBuffer(buffer, tryFree);
        this.memoryAddress = PlatformDependent.directBufferAddress(buffer);
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.addr(index2));
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.addr(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(index2));
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.addr(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(index2));
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.addr(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return UnsafeByteBufUtil.getLongLE(this.addr(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index2), index2, dst, dstIndex, length2);
        return this;
    }

    @Override
    void getBytes(int index2, byte[] dst, int dstIndex, int length2, boolean internal) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(index2), index2, dst, dstIndex, length2);
    }

    @Override
    void getBytes(int index2, ByteBuffer dst, boolean internal) {
        UnsafeByteBufUtil.getBytes(this, this.addr(index2), index2, dst);
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.checkIndex(index2);
        this._setByte(index2, value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        UnsafeByteBufUtil.setByte(this.addr(index2), value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        UnsafeByteBufUtil.setShort(this.addr(index2), value2);
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        UnsafeByteBufUtil.setShortLE(this.addr(index2), value2);
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        UnsafeByteBufUtil.setMedium(this.addr(index2), value2);
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        UnsafeByteBufUtil.setMediumLE(this.addr(index2), value2);
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        UnsafeByteBufUtil.setInt(this.addr(index2), value2);
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        UnsafeByteBufUtil.setIntLE(this.addr(index2), value2);
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        UnsafeByteBufUtil.setLong(this.addr(index2), value2);
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        UnsafeByteBufUtil.setLongLE(this.addr(index2), value2);
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index2), index2, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(index2), index2, src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        UnsafeByteBufUtil.setBytes(this, this.addr(index2), index2, src);
        return this;
    }

    @Override
    void getBytes(int index2, OutputStream out, int length2, boolean internal) throws IOException {
        UnsafeByteBufUtil.getBytes(this, this.addr(index2), index2, out, length2);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        return UnsafeByteBufUtil.setBytes(this, this.addr(index2), index2, in, length2);
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        return UnsafeByteBufUtil.copy(this, this.addr(index2), index2, length2);
    }

    final long addr(int index2) {
        return this.memoryAddress + (long)index2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int index2, int length2) {
        this.checkIndex(index2, length2);
        UnsafeByteBufUtil.setZero(this.addr(index2), length2);
        return this;
    }

    @Override
    public ByteBuf writeZero(int length2) {
        this.ensureWritable(length2);
        int wIndex = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(wIndex), length2);
        this.writerIndex = wIndex + length2;
        return this;
    }
}

