/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.HeapByteBufUtil;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectPool;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

class PooledHeapByteBuf
extends PooledByteBuf<byte[]> {
    private static final ObjectPool<PooledHeapByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledHeapByteBuf>(){

        @Override
        public PooledHeapByteBuf newObject(ObjectPool.Handle<PooledHeapByteBuf> handle) {
            return new PooledHeapByteBuf((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, 0);
        }
    });

    static PooledHeapByteBuf newInstance(int maxCapacity) {
        PooledHeapByteBuf buf = RECYCLER.get();
        buf.reuse(maxCapacity);
        return buf;
    }

    PooledHeapByteBuf(ObjectPool.Handle<? extends PooledHeapByteBuf> recyclerHandle, int maxCapacity) {
        super(recyclerHandle, maxCapacity);
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    protected byte _getByte(int index2) {
        return HeapByteBufUtil.getByte((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return HeapByteBufUtil.getShort((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return HeapByteBufUtil.getShortLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return HeapByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return HeapByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return HeapByteBufUtil.getInt((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return HeapByteBufUtil.getIntLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return HeapByteBufUtil.getLong((byte[])this.memory, this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return HeapByteBufUtil.getLongLE((byte[])this.memory, this.idx(index2));
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.memory, this.idx(index2), dst.memoryAddress() + (long)dstIndex, (long)length2);
        } else if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length2);
        } else {
            dst.setBytes(dstIndex, (byte[])this.memory, this.idx(index2), length2);
        }
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkDstIndex(index2, length2, dstIndex, dst.length);
        System.arraycopy(this.memory, this.idx(index2), dst, dstIndex, length2);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, ByteBuffer dst) {
        int length2 = dst.remaining();
        this.checkIndex(index2, length2);
        dst.put((byte[])this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.checkIndex(index2, length2);
        out.write((byte[])this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        HeapByteBufUtil.setByte((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setShort(int index2, int value2) {
        HeapByteBufUtil.setShort((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        HeapByteBufUtil.setShortLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        HeapByteBufUtil.setMedium((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        HeapByteBufUtil.setMediumLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setInt(int index2, int value2) {
        HeapByteBufUtil.setInt((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        HeapByteBufUtil.setIntLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setLong(int index2, long value2) {
        HeapByteBufUtil.setLong((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        HeapByteBufUtil.setLongLE((byte[])this.memory, this.idx(index2), value2);
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.capacity());
        if (src.hasMemoryAddress()) {
            PlatformDependent.copyMemory(src.memoryAddress() + (long)srcIndex, (byte[])this.memory, this.idx(index2), (long)length2);
        } else if (src.hasArray()) {
            this.setBytes(index2, src.array(), src.arrayOffset() + srcIndex, length2);
        } else {
            src.getBytes(srcIndex, (byte[])this.memory, this.idx(index2), length2);
        }
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkSrcIndex(index2, length2, srcIndex, src.length);
        System.arraycopy(src, srcIndex, this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final ByteBuf setBytes(int index2, ByteBuffer src) {
        int length2 = src.remaining();
        this.checkIndex(index2, length2);
        src.get((byte[])this.memory, this.idx(index2), length2);
        return this;
    }

    @Override
    public final int setBytes(int index2, InputStream in, int length2) throws IOException {
        this.checkIndex(index2, length2);
        return in.read((byte[])this.memory, this.idx(index2), length2);
    }

    @Override
    public final ByteBuf copy(int index2, int length2) {
        this.checkIndex(index2, length2);
        ByteBuf copy = this.alloc().heapBuffer(length2, this.maxCapacity());
        return copy.writeBytes((byte[])this.memory, this.idx(index2), length2);
    }

    @Override
    final ByteBuffer duplicateInternalNioBuffer(int index2, int length2) {
        this.checkIndex(index2, length2);
        return ByteBuffer.wrap((byte[])this.memory, this.idx(index2), length2).slice();
    }

    @Override
    public final boolean hasArray() {
        return true;
    }

    @Override
    public final byte[] array() {
        this.ensureAccessible();
        return (byte[])this.memory;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final ByteBuffer newInternalNioBuffer(byte[] memory) {
        return ByteBuffer.wrap(memory);
    }
}

