/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.util.Arrays;

final class LongPriorityQueue {
    public static final int NO_VALUE = -1;
    private long[] array = new long[9];
    private int size;

    LongPriorityQueue() {
    }

    public void offer(long handle) {
        if (handle == -1L) {
            throw new IllegalArgumentException("The NO_VALUE (-1) cannot be added to the queue.");
        }
        ++this.size;
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, 1 + (this.array.length - 1) * 2);
        }
        this.array[this.size] = handle;
        this.lift(this.size);
    }

    public void remove(long value2) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.array[i2] != value2) continue;
            this.array[i2] = this.array[this.size--];
            this.lift(i2);
            this.sink(i2);
            return;
        }
    }

    public long peek() {
        if (this.size == 0) {
            return -1L;
        }
        return this.array[1];
    }

    public long poll() {
        if (this.size == 0) {
            return -1L;
        }
        long val = this.array[1];
        this.array[1] = this.array[this.size];
        this.array[this.size] = 0L;
        --this.size;
        this.sink(1);
        return val;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void lift(int index2) {
        int parentIndex;
        while (index2 > 1 && this.subord(parentIndex = index2 >> 1, index2)) {
            this.swap(index2, parentIndex);
            index2 = parentIndex;
        }
    }

    private void sink(int index2) {
        int child;
        while ((child = index2 << 1) <= this.size) {
            if (child < this.size && this.subord(child, child + 1)) {
                ++child;
            }
            if (!this.subord(index2, child)) break;
            this.swap(index2, child);
            index2 = child;
        }
    }

    private boolean subord(int a, int b) {
        return this.array[a] > this.array[b];
    }

    private void swap(int a, int b) {
        long value2 = this.array[a];
        this.array[a] = this.array[b];
        this.array[b] = value2;
    }
}

