/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.LazyStringArrayList;
import org.apache.hbase.thirdparty.com.google.protobuf.LazyStringList;
import org.apache.hbase.thirdparty.com.google.protobuf.PrimitiveNonBoxingCollection;
import org.apache.hbase.thirdparty.com.google.protobuf.UnmodifiableLazyStringList;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeUtil;

abstract class ListFieldSchema {
    private static final ListFieldSchema FULL_INSTANCE = new ListFieldSchemaFull();
    private static final ListFieldSchema LITE_INSTANCE = new ListFieldSchemaLite();

    private ListFieldSchema() {
    }

    abstract <L> List<L> mutableListAt(Object var1, long var2);

    abstract void makeImmutableListAt(Object var1, long var2);

    abstract <L> void mergeListsAt(Object var1, Object var2, long var3);

    static ListFieldSchema full() {
        return FULL_INSTANCE;
    }

    static ListFieldSchema lite() {
        return LITE_INSTANCE;
    }

    private static final class ListFieldSchemaLite
    extends ListFieldSchema {
        private ListFieldSchemaLite() {
        }

        @Override
        <L> List<L> mutableListAt(Object message2, long offset2) {
            Internal.ProtobufList list2 = ListFieldSchemaLite.getProtobufList(message2, offset2);
            if (!list2.isModifiable()) {
                int size2 = list2.size();
                list2 = list2.mutableCopyWithCapacity(size2 == 0 ? 10 : size2 * 2);
                UnsafeUtil.putObject(message2, offset2, list2);
            }
            return list2;
        }

        @Override
        void makeImmutableListAt(Object message2, long offset2) {
            Internal.ProtobufList list2 = ListFieldSchemaLite.getProtobufList(message2, offset2);
            list2.makeImmutable();
        }

        @Override
        <E> void mergeListsAt(Object msg, Object otherMsg, long offset2) {
            Internal.ProtobufList<E> mine = ListFieldSchemaLite.getProtobufList(msg, offset2);
            Internal.ProtobufList<E> other = ListFieldSchemaLite.getProtobufList(otherMsg, offset2);
            int size2 = mine.size();
            int otherSize = other.size();
            if (size2 > 0 && otherSize > 0) {
                if (!mine.isModifiable()) {
                    mine = mine.mutableCopyWithCapacity(size2 + otherSize);
                }
                mine.addAll(other);
            }
            Internal.ProtobufList<E> merged = size2 > 0 ? mine : other;
            UnsafeUtil.putObject(msg, offset2, merged);
        }

        static <E> Internal.ProtobufList<E> getProtobufList(Object message2, long offset2) {
            return (Internal.ProtobufList)UnsafeUtil.getObject(message2, offset2);
        }
    }

    private static final class ListFieldSchemaFull
    extends ListFieldSchema {
        private static final Class<?> UNMODIFIABLE_LIST_CLASS = Collections.unmodifiableList(Collections.emptyList()).getClass();

        private ListFieldSchemaFull() {
        }

        @Override
        <L> List<L> mutableListAt(Object message2, long offset2) {
            return ListFieldSchemaFull.mutableListAt(message2, offset2, 10);
        }

        @Override
        void makeImmutableListAt(Object message2, long offset2) {
            List list2 = (List)UnsafeUtil.getObject(message2, offset2);
            List<String> immutable = null;
            if (list2 instanceof LazyStringList) {
                immutable = ((LazyStringList)list2).getUnmodifiableView();
            } else {
                if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list2.getClass())) {
                    return;
                }
                if (list2 instanceof PrimitiveNonBoxingCollection && list2 instanceof Internal.ProtobufList) {
                    if (((Internal.ProtobufList)list2).isModifiable()) {
                        ((Internal.ProtobufList)list2).makeImmutable();
                    }
                    return;
                }
                immutable = Collections.unmodifiableList(list2);
            }
            UnsafeUtil.putObject(message2, offset2, (Object)immutable);
        }

        private static <L> List<L> mutableListAt(Object message2, long offset2, int additionalCapacity) {
            List<String> list2 = ListFieldSchemaFull.getList(message2, offset2);
            if (list2.isEmpty()) {
                list2 = list2 instanceof LazyStringList ? new LazyStringArrayList(additionalCapacity) : (list2 instanceof PrimitiveNonBoxingCollection && list2 instanceof Internal.ProtobufList ? ((Internal.ProtobufList)list2).mutableCopyWithCapacity(additionalCapacity) : new ArrayList(additionalCapacity));
                UnsafeUtil.putObject(message2, offset2, (Object)list2);
            } else if (UNMODIFIABLE_LIST_CLASS.isAssignableFrom(list2.getClass())) {
                ArrayList<String> newList = new ArrayList<String>(list2.size() + additionalCapacity);
                newList.addAll(list2);
                list2 = newList;
                UnsafeUtil.putObject(message2, offset2, list2);
            } else if (list2 instanceof UnmodifiableLazyStringList) {
                LazyStringArrayList newList = new LazyStringArrayList(list2.size() + additionalCapacity);
                newList.addAll((UnmodifiableLazyStringList)list2);
                list2 = newList;
                UnsafeUtil.putObject(message2, offset2, list2);
            } else if (list2 instanceof PrimitiveNonBoxingCollection && list2 instanceof Internal.ProtobufList && !((Internal.ProtobufList)list2).isModifiable()) {
                list2 = ((Internal.ProtobufList)list2).mutableCopyWithCapacity(list2.size() + additionalCapacity);
                UnsafeUtil.putObject(message2, offset2, list2);
            }
            return list2;
        }

        @Override
        <E> void mergeListsAt(Object msg, Object otherMsg, long offset2) {
            List<E> other = ListFieldSchemaFull.getList(otherMsg, offset2);
            List mine = ListFieldSchemaFull.mutableListAt(msg, offset2, other.size());
            int size2 = mine.size();
            int otherSize = other.size();
            if (size2 > 0 && otherSize > 0) {
                mine.addAll(other);
            }
            List<Object> merged = size2 > 0 ? mine : other;
            UnsafeUtil.putObject(msg, offset2, merged);
        }

        static <E> List<E> getList(Object message2, long offset2) {
            return (List)UnsafeUtil.getObject(message2, offset2);
        }
    }
}

