/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.util.AbstractPositionedByteRange;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class SimplePositionedMutableByteRange
extends AbstractPositionedByteRange {
    public SimplePositionedMutableByteRange() {
    }

    public SimplePositionedMutableByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimplePositionedMutableByteRange(byte[] bytes2) {
        this.set(bytes2);
    }

    public SimplePositionedMutableByteRange(byte[] bytes2, int offset2, int length2) {
        this.set(bytes2, offset2, length2);
    }

    @Override
    public PositionedByteRange unset() {
        this.position = 0;
        this.clearHashCache();
        this.bytes = null;
        this.offset = 0;
        this.length = 0;
        return this;
    }

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        this.limit = capacity;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes2) {
        this.position = 0;
        super.set(bytes2);
        this.limit = bytes2.length;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes2, int offset2, int length2) {
        this.position = 0;
        super.set(bytes2, offset2, length2);
        this.limit = length2;
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset2) {
        this.position = 0;
        super.setOffset(offset2);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length2) {
        this.position = Math.min(this.position, length2);
        super.setLength(length2);
        return this;
    }

    @Override
    public PositionedByteRange put(byte val) {
        this.put(this.position++, val);
        return this;
    }

    @Override
    public PositionedByteRange put(byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(val, 0, val.length);
    }

    @Override
    public PositionedByteRange put(byte[] val, int offset2, int length2) {
        if (0 == length2) {
            return this;
        }
        this.put(this.position, val, offset2, length2);
        this.position += length2;
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst) {
        super.get(index2, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst, int offset2, int length2) {
        super.get(index2, dst, offset2, length2);
        return this;
    }

    @Override
    public PositionedByteRange put(int index2, byte val) {
        this.bytes[this.offset + index2] = val;
        return this;
    }

    @Override
    public PositionedByteRange put(int index2, byte[] val) {
        if (0 == val.length) {
            return this;
        }
        return this.put(index2, val, 0, val.length);
    }

    @Override
    public PositionedByteRange put(int index2, byte[] val, int offset2, int length2) {
        if (0 == length2) {
            return this;
        }
        System.arraycopy(val, offset2, this.bytes, this.offset + index2, length2);
        return this;
    }

    @Override
    public PositionedByteRange deepCopy() {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.deepCopyToNewArray());
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange shallowCopy() {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.bytes, this.offset, this.length);
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimplePositionedMutableByteRange clone = new SimplePositionedMutableByteRange(this.bytes, this.offset + innerOffset, copyLength);
        clone.position = this.position;
        return clone;
    }

    @Override
    public PositionedByteRange putShort(short val) {
        this.putShort(this.position, val);
        this.position += 2;
        return this;
    }

    @Override
    public PositionedByteRange putInt(int val) {
        this.putInt(this.position, val);
        this.position += 4;
        return this;
    }

    @Override
    public PositionedByteRange putLong(long val) {
        this.putLong(this.position, val);
        this.position += 8;
        return this;
    }

    @Override
    public int putVLong(long val) {
        int len = this.putVLong(this.position, val);
        this.position += len;
        return len;
    }

    @Override
    public PositionedByteRange putShort(int index2, short val) {
        this.bytes[this.offset + index2 + 1] = (byte)val;
        val = (short)(val >> 8);
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public PositionedByteRange putInt(int index2, int val) {
        for (int i2 = 3; i2 > 0; --i2) {
            this.bytes[this.offset + index2 + i2] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public PositionedByteRange putLong(int index2, long val) {
        for (int i2 = 7; i2 > 0; --i2) {
            this.bytes[this.offset + index2 + i2] = (byte)val;
            val >>>= 8;
        }
        this.bytes[this.offset + index2] = (byte)val;
        this.clearHashCache();
        return this;
    }

    @Override
    public int putVLong(int index2, long val) {
        int rPos = 0;
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.bytes[this.offset + index2 + rPos] = (byte)(val & 0x7FL | 0x80L);
            val >>>= 7;
            ++rPos;
        }
        this.bytes[this.offset + index2 + rPos] = (byte)val;
        this.clearHashCache();
        return rPos + 1;
    }
}

