/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ReadOnlyByteRangeException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SimpleByteRange
extends AbstractByteRange {
    public SimpleByteRange() {
    }

    public SimpleByteRange(int capacity) {
        this(new byte[capacity]);
    }

    public SimpleByteRange(byte[] bytes2) {
        this.set(bytes2);
    }

    public SimpleByteRange(byte[] bytes2, int offset2, int length2) {
        this.set(bytes2, offset2, length2);
    }

    @Override
    public ByteRange unset() {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange set(int capacity) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(capacity);
    }

    @Override
    public ByteRange set(byte[] bytes2) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(bytes2);
    }

    @Override
    public ByteRange set(byte[] bytes2, int offset2, int length2) {
        if (this.bytes != null) {
            throw new ReadOnlyByteRangeException();
        }
        return super.set(bytes2, offset2, length2);
    }

    @Override
    public ByteRange put(int index2, byte val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange put(int index2, byte[] val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange put(int index2, byte[] val, int offset2, int length2) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange shallowCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset, this.length);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange shallowCopySubRange(int innerOffset, int copyLength) {
        SimpleByteRange clone = new SimpleByteRange(this.bytes, this.offset + innerOffset, copyLength);
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (thatObject == null) {
            return false;
        }
        if (this == thatObject) {
            return true;
        }
        if (this.hashCode() != thatObject.hashCode()) {
            return false;
        }
        if (!(thatObject instanceof SimpleByteRange)) {
            return false;
        }
        SimpleByteRange that = (SimpleByteRange)thatObject;
        return Bytes.equals(this.bytes, this.offset, this.length, that.bytes, that.offset, that.length);
    }

    @Override
    public ByteRange deepCopy() {
        SimpleByteRange clone = new SimpleByteRange(this.deepCopyToNewArray());
        if (this.isHashCached()) {
            clone.hash = this.hash;
        }
        return clone;
    }

    @Override
    public ByteRange putInt(int index2, int val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange putLong(int index2, long val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public ByteRange putShort(int index2, short val) {
        throw new ReadOnlyByteRangeException();
    }

    @Override
    public int putVLong(int index2, long val) {
        throw new ReadOnlyByteRangeException();
    }
}

